/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.util.EqualsHelper;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class TestWebScriptRepoServer
extends TestWebScriptServer {
    private static final String[] CONFIG_LOCATIONS = new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/web-scripts-application-context-test.xml"};
    private static ClassPathXmlApplicationContext ctx;
    private static String appendedTestConfiguration;
    private RetryingTransactionHelper retryingTransactionHelper;
    private AuthenticationService authenticationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            TestWebScriptServer testServer = TestWebScriptRepoServer.getTestServer();
            AuthenticationUtil.setRunAsUserSystem();
            testServer.rep();
        }
        catch (Throwable e) {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            e.printStackTrace(printWriter);
            System.out.println(strWriter.toString());
        }
        finally {
            System.exit(0);
        }
    }

    public void setTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected String getDefaultUserName() {
        return AuthenticationUtil.getAdminUserName();
    }

    public static TestWebScriptServer getTestServer() {
        return TestWebScriptRepoServer.getTestServer(null);
    }

    public static synchronized TestWebScriptServer getTestServer(String appendTestConfigLocation) {
        if (ctx != null) {
            boolean configChanged;
            boolean bl = configChanged = !EqualsHelper.nullSafeEquals((Object)appendTestConfigLocation, (Object)appendedTestConfiguration);
            if (configChanged) {
                try {
                    ctx.close();
                    ctx = null;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Failed to shut down existing application context", e);
                }
            }
        }
        if (ctx == null) {
            String[] configLocations;
            if (appendTestConfigLocation == null) {
                configLocations = CONFIG_LOCATIONS;
            } else {
                configLocations = new String[CONFIG_LOCATIONS.length + 1];
                System.arraycopy(CONFIG_LOCATIONS, 0, configLocations, 0, CONFIG_LOCATIONS.length);
                configLocations[TestWebScriptRepoServer.CONFIG_LOCATIONS.length] = appendTestConfigLocation;
            }
            ctx = new ClassPathXmlApplicationContext(configLocations);
            appendedTestConfiguration = appendTestConfigLocation;
        }
        org.alfresco.repo.web.scripts.TestWebScriptRepoServer testServer = (org.alfresco.repo.web.scripts.TestWebScriptRepoServer)ctx.getBean("webscripts.test");
        return testServer;
    }

    protected String interpretCommand(final String line) throws IOException {
        block5: {
            String string;
            if (!this.username.startsWith("TICKET_")) break block5;
            try {
                this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Exception {
                        TestWebScriptRepoServer.this.authenticationService.validate(TestWebScriptRepoServer.this.username);
                        return null;
                    }
                });
                string = this.executeCommand(line);
            }
            catch (Throwable throwable) {
                try {
                    this.authenticationService.clearCurrentSecurityContext();
                    throw throwable;
                }
                catch (AuthenticationException e) {
                    this.executeCommand("user " + this.getDefaultUserName());
                }
            }
            this.authenticationService.clearCurrentSecurityContext();
            return string;
        }
        return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return TestWebScriptRepoServer.this.executeCommand(line);
            }
        }, (String)this.username);
    }
}

