/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchParameters;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchService;
import org.alfresco.module.org_alfresco_module_rm.search.ReportDetails;
import org.alfresco.module.org_alfresco_module_rm.search.SavedSearchDetails;
import org.alfresco.module.org_alfresco_module_rm.search.SortItem;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.I18NUtil;

public class RecordsManagementSearchServiceImpl
implements RecordsManagementSearchService {
    private static final String SITES_SPACE_QNAME_PATH = "/app:company_home/st:sites/";
    private static final String SEARCH_CONTAINER = "Saved Searches";
    private FileFolderService fileFolderService;
    private SearchService searchService;
    private SiteService siteService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private List<ReportDetails> reports = new ArrayList<ReportDetails>(13);
    private RecordsManagementSearchParameters recordsManagementSearchParameters;

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setReportsJSON(String reportsJSON) {
        try {
            JSONArray jsonArray = new JSONArray(reportsJSON);
            for (int i = 0; i < jsonArray.length(); ++i) {
                String translatedDescription;
                JSONObject report = jsonArray.getJSONObject(i);
                if (!report.has("name")) {
                    throw new AlfrescoRuntimeException("Unable to load report details because name has not been specified. \n" + reportsJSON);
                }
                String name = report.getString("name");
                String translatedName = I18NUtil.getMessage((String)name);
                if (translatedName != null) {
                    name = translatedName;
                }
                if (!report.has("search")) {
                    throw new AlfrescoRuntimeException("Unable to load report details because search has not been specified for report " + name + ". \n" + reportsJSON);
                }
                String query = report.getString("search");
                String description = "";
                if (report.has("description") && (translatedDescription = I18NUtil.getMessage((String)(description = report.getString("description")))) != null) {
                    description = translatedDescription;
                }
                if (report.has("searchparams")) {
                    this.recordsManagementSearchParameters = RecordsManagementSearchParameters.createFromJSON(report.getJSONObject("searchparams"), this.namespaceService);
                }
                ReportDetails reportDetails = new ReportDetails(name, description, query, this.recordsManagementSearchParameters);
                this.reports.add(reportDetails);
            }
        }
        catch (JSONException exception) {
            throw new AlfrescoRuntimeException("Unable to load report details.\n" + reportsJSON, (Throwable)exception);
        }
    }

    public void setRecordsManagementSearchParameters(RecordsManagementSearchParameters recordsManagementSearchParameters) {
        this.recordsManagementSearchParameters = recordsManagementSearchParameters;
    }

    @Override
    public List<Pair<NodeRef, NodeRef>> search(String siteId, String query, RecordsManagementSearchParameters rmSearchParameters) {
        StringBuilder fullQuery = new StringBuilder(1024);
        fullQuery.append("PATH:\"").append(SITES_SPACE_QNAME_PATH).append("cm:").append(ISO9075.encode((String)siteId)).append("/cm:documentLibrary//*\"").append(" AND (").append(this.buildQueryString(query, rmSearchParameters)).append(")");
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setQuery(fullQuery.toString());
        searchParameters.setLanguage("fts-alfresco");
        searchParameters.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        searchParameters.setMaxItems(this.recordsManagementSearchParameters.getMaxItems());
        searchParameters.setNamespace("http://www.alfresco.org/model/recordsmanagement/1.0");
        for (SortItem sortItem : rmSearchParameters.getSortOrder()) {
            searchParameters.addSort(sortItem.property.toPrefixString((NamespacePrefixResolver)this.namespaceService), sortItem.assc);
        }
        for (Map.Entry entry : rmSearchParameters.getTemplates().entrySet()) {
            searchParameters.addQueryTemplate((String)entry.getKey(), (String)entry.getValue());
        }
        ResultSet resultSet = this.searchService.query(searchParameters);
        ArrayList<Pair<NodeRef, NodeRef>> arrayList = new ArrayList<Pair<NodeRef, NodeRef>>(resultSet.length());
        for (ChildAssociationRef childAssoc : resultSet.getChildAssocRefs()) {
            arrayList.add((Pair<NodeRef, NodeRef>)new Pair((Object)childAssoc.getParentRef(), (Object)childAssoc.getChildRef()));
        }
        return arrayList;
    }

    String buildQueryString(String queryTerm, RecordsManagementSearchParameters searchParameters) {
        List<QName> includedContainerTypes;
        StringBuilder aspectQuery = new StringBuilder();
        if (searchParameters.isIncludeRecords()) {
            this.appendAspect(aspectQuery, "rma:record");
            if (!searchParameters.isIncludeUndeclaredRecords()) {
                this.appendAspect(aspectQuery, "rma:declaredRecord");
            }
            if (searchParameters.isIncludeVitalRecords()) {
                this.appendAspect(aspectQuery, "rma:vitalRecord");
            }
        }
        StringBuilder typeQuery = new StringBuilder();
        if (searchParameters.isIncludeRecordFolders()) {
            this.appendType(typeQuery, "rma:recordFolder");
        }
        if ((includedContainerTypes = searchParameters.getIncludedContainerTypes()) != null && includedContainerTypes.size() != 0) {
            for (QName includedContainerType : includedContainerTypes) {
                this.appendType(typeQuery, includedContainerType.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            }
        }
        StringBuilder query = new StringBuilder();
        if (queryTerm == null || queryTerm.length() == 0) {
            query.append("ISNODE:T");
        } else if (this.isComplexQueryTerm(queryTerm)) {
            query.append(queryTerm);
        } else {
            query.append("keywords:\"" + queryTerm + "\"");
        }
        StringBuilder fullQuery = new StringBuilder(1024);
        if (aspectQuery.length() != 0 || typeQuery.length() != 0) {
            if (aspectQuery.length() != 0 && typeQuery.length() != 0) {
                fullQuery.append("(");
            }
            if (aspectQuery.length() != 0) {
                fullQuery.append("(").append((CharSequence)aspectQuery).append(") ");
            }
            if (typeQuery.length() != 0) {
                fullQuery.append("(").append((CharSequence)typeQuery).append(")");
            }
            if (aspectQuery.length() != 0 && typeQuery.length() != 0) {
                fullQuery.append(")");
            }
        }
        if (searchParameters.isIncludeFrozen()) {
            this.appendAspect(fullQuery, "rma:frozen");
        } else {
            this.appendNotAspect(fullQuery, "rma:frozen");
        }
        if (searchParameters.isIncludeCutoff()) {
            this.appendAspect(fullQuery, "rma:cutOff");
        }
        if (fullQuery.length() != 0) {
            fullQuery.append(" AND ");
        }
        fullQuery.append((CharSequence)query).append(" AND NOT ASPECT:\"rma:versionedRecord\"");
        return fullQuery.toString();
    }

    private boolean isComplexQueryTerm(String query) {
        return query.matches(".*[\":].*");
    }

    private void appendAspect(StringBuilder sb, String aspect) {
        this.appendWithJoin(sb, " AND ", "ASPECT:\"", aspect, "\"");
    }

    private void appendNotAspect(StringBuilder sb, String aspect) {
        this.appendWithJoin(sb, " AND ", "NOT ASPECT:\"", aspect, "\"");
    }

    private void appendType(StringBuilder sb, String type) {
        this.appendWithJoin(sb, " ", "TYPE:\"", type, "\"");
    }

    private void appendWithJoin(StringBuilder sb, String withJoin, String prefix, String value, String postfix) {
        if (sb.length() != 0) {
            sb.append(withJoin);
        }
        sb.append(prefix).append(value).append(postfix);
    }

    @Override
    public List<SavedSearchDetails> getSavedSearches(String siteId) {
        ArrayList<SavedSearchDetails> result = new ArrayList<SavedSearchDetails>(17);
        NodeRef container = this.siteService.getContainer(siteId, SEARCH_CONTAINER);
        if (container != null) {
            List searches = this.fileFolderService.listFiles(container);
            for (FileInfo search : searches) {
                this.addSearchDetailsToList(result, search.getNodeRef());
            }
            String userName = AuthenticationUtil.getFullyAuthenticatedUser();
            NodeRef userContainer = this.fileFolderService.searchSimple(container, userName);
            if (userContainer != null) {
                List userSearches = this.fileFolderService.listFiles(userContainer);
                for (FileInfo userSearch : userSearches) {
                    this.addSearchDetailsToList(result, userSearch.getNodeRef());
                }
            }
        }
        return result;
    }

    private void addSearchDetailsToList(List<SavedSearchDetails> searches, NodeRef searchNode) {
        ContentReader reader = this.fileFolderService.getReader(searchNode);
        String jsonString = reader.getContentString();
        SavedSearchDetails savedSearchDetails = SavedSearchDetails.createFromJSON(jsonString, this.namespaceService, this, searchNode);
        searches.add(savedSearchDetails);
    }

    @Override
    public SavedSearchDetails getSavedSearch(String siteId, String name) {
        ParameterCheck.mandatory((String)"siteId", (Object)siteId);
        ParameterCheck.mandatory((String)"name", (Object)name);
        SavedSearchDetails result = null;
        NodeRef searchNode = this.getSearchNodeRef(siteId, name);
        if (searchNode != null) {
            ContentReader reader = this.fileFolderService.getReader(searchNode);
            String jsonString = reader.getContentString();
            result = SavedSearchDetails.createFromJSON(jsonString, this.namespaceService, this, searchNode);
        }
        return result;
    }

    @Override
    public SavedSearchDetails saveSearch(String siteId, String name, String description, String query, RecordsManagementSearchParameters searchParameters, boolean isPublic) {
        ParameterCheck.mandatory((String)"siteId", (Object)siteId);
        ParameterCheck.mandatory((String)"name", (Object)name);
        ParameterCheck.mandatory((String)"query", (Object)query);
        ParameterCheck.mandatory((String)"searchParameters", (Object)searchParameters);
        SavedSearchDetails savedSearchDetails = new SavedSearchDetails(siteId, name, description, query, searchParameters, isPublic, false, this.namespaceService, this);
        return this.saveSearch(savedSearchDetails);
    }

    @Override
    public SavedSearchDetails saveSearch(final SavedSearchDetails savedSearchDetails) {
        NodeRef searchNode;
        ParameterCheck.mandatory((String)"savedSearchDetails", (Object)savedSearchDetails);
        final String siteId = savedSearchDetails.getSiteId();
        NodeRef container = this.siteService.getContainer(siteId, SEARCH_CONTAINER);
        if (container == null) {
            container = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() {
                    return RecordsManagementSearchServiceImpl.this.siteService.createContainer(siteId, RecordsManagementSearchServiceImpl.SEARCH_CONTAINER, null, null);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
        if (!savedSearchDetails.isPublic()) {
            final String userName = AuthenticationUtil.getFullyAuthenticatedUser();
            NodeRef userContainer = this.fileFolderService.searchSimple(container, userName);
            if (userContainer == null) {
                final NodeRef parentContainer = container;
                userContainer = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                    public NodeRef doWork() {
                        return RecordsManagementSearchServiceImpl.this.fileFolderService.create(parentContainer, userName, ContentModel.TYPE_FOLDER).getNodeRef();
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
            container = userContainer;
        }
        if ((searchNode = this.fileFolderService.searchSimple(container, savedSearchDetails.getName())) == null) {
            final NodeRef searchContainer = container;
            searchNode = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() {
                    return RecordsManagementSearchServiceImpl.this.fileFolderService.create(searchContainer, savedSearchDetails.getName(), ContentModel.TYPE_CONTENT).getNodeRef();
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
        this.nodeService.addAspect(searchNode, RecordsManagementModel.ASPECT_SAVED_SEARCH, null);
        final NodeRef writableSearchNode = searchNode;
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                ContentWriter writer = RecordsManagementSearchServiceImpl.this.fileFolderService.getWriter(writableSearchNode);
                writer.setEncoding("UTF-8");
                writer.setMimetype("application/json");
                writer.putContent(savedSearchDetails.toJSONString());
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return savedSearchDetails;
    }

    @Override
    public void deleteSavedSearch(String siteId, String name) {
        ParameterCheck.mandatory((String)"siteId", (Object)siteId);
        ParameterCheck.mandatory((String)"name", (Object)name);
        NodeRef searchNode = this.getSearchNodeRef(siteId, name);
        if (searchNode != null && this.fileFolderService.exists(searchNode)) {
            this.fileFolderService.delete(searchNode);
        }
    }

    @Override
    public void deleteSavedSearch(SavedSearchDetails savedSearchDetails) {
        ParameterCheck.mandatory((String)"savedSearchDetails", (Object)savedSearchDetails);
        this.deleteSavedSearch(savedSearchDetails.getSiteId(), savedSearchDetails.getName());
    }

    private NodeRef getSearchNodeRef(String siteId, String name) {
        String userName;
        NodeRef userContainer;
        NodeRef searchNode = null;
        NodeRef container = this.siteService.getContainer(siteId, SEARCH_CONTAINER);
        if (container != null && (searchNode = this.fileFolderService.searchSimple(container, name)) == null && (userContainer = this.fileFolderService.searchSimple(container, userName = AuthenticationUtil.getFullyAuthenticatedUser())) != null) {
            searchNode = this.fileFolderService.searchSimple(userContainer, name);
        }
        return searchNode;
    }

    @Override
    public void addReports(String siteId) {
        for (ReportDetails report : this.reports) {
            SavedSearchDetails savedSearchDetails = new SavedSearchDetails(siteId, report.getName(), report.getDescription(), report.getSearch(), report.getSearchParameters(), true, true, this.namespaceService, this);
            this.saveSearch(savedSearchDetails);
        }
    }
}

