/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.vital;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinition;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinitionImpl;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordService;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;

@BehaviourBean
public class VitalRecordServiceImpl
extends ServiceBaseImpl
implements VitalRecordService,
RecordsManagementModel,
RecordsManagementPolicies.OnFileRecord {
    private FilePlanService filePlanService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    @Override
    @Behaviour(kind=BehaviourKind.CLASS, type="rma:record")
    public void onFileRecord(NodeRef nodeRef) {
        VitalRecordDefinition viDef = this.getVitalRecordDefinition(nodeRef);
        if (viDef != null && viDef.isEnabled()) {
            Date reviewAsOf = viDef.getNextReviewDate();
            if (reviewAsOf != null) {
                HashMap<QName, Date> reviewProps = new HashMap<QName, Date>(1);
                reviewProps.put(RecordsManagementModel.PROP_REVIEW_AS_OF, reviewAsOf);
                if (!this.nodeService.hasAspect(nodeRef, ASPECT_VITAL_RECORD)) {
                    this.nodeService.addAspect(nodeRef, RecordsManagementModel.ASPECT_VITAL_RECORD, reviewProps);
                } else {
                    Map props = this.nodeService.getProperties(nodeRef);
                    props.putAll(reviewProps);
                    this.nodeService.setProperties(nodeRef, props);
                }
            }
        } else if (this.nodeService.hasAspect(nodeRef, ASPECT_VITAL_RECORD)) {
            this.nodeService.removeAspect(nodeRef, ASPECT_VITAL_RECORD);
        }
    }

    @Override
    public void setupVitalRecordDefinition(NodeRef nodeRef) {
        FilePlanComponentKind kind;
        NodeRef parentRef;
        Period currentReviewPeriod = (Period)this.nodeService.getProperty(nodeRef, PROP_REVIEW_PERIOD);
        if ((currentReviewPeriod == null || PERIOD_NONE.equals((Object)currentReviewPeriod)) && (parentRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef()) != null && FilePlanComponentKind.RECORD_CATEGORY.equals((Object)this.filePlanService.getFilePlanComponentKind(parentRef)) && ((kind = this.filePlanService.getFilePlanComponentKind(nodeRef)).equals((Object)FilePlanComponentKind.RECORD_CATEGORY) || kind.equals((Object)FilePlanComponentKind.RECORD_FOLDER))) {
            this.nodeService.setProperty(nodeRef, PROP_VITAL_RECORD_INDICATOR, this.nodeService.getProperty(parentRef, PROP_VITAL_RECORD_INDICATOR));
            this.nodeService.setProperty(nodeRef, PROP_REVIEW_PERIOD, this.nodeService.getProperty(parentRef, PROP_REVIEW_PERIOD));
        }
    }

    @Override
    public VitalRecordDefinition getVitalRecordDefinition(NodeRef nodeRef) {
        VitalRecordDefinition result = null;
        FilePlanComponentKind kind = this.filePlanService.getFilePlanComponentKind(nodeRef);
        if (FilePlanComponentKind.RECORD.equals((Object)kind)) {
            result = this.resolveVitalRecordDefinition(nodeRef);
        } else if (this.nodeService.hasAspect(nodeRef, ASPECT_VITAL_RECORD_DEFINITION)) {
            result = VitalRecordDefinitionImpl.create(this.nodeService, nodeRef);
        }
        return result;
    }

    private VitalRecordDefinition resolveVitalRecordDefinition(NodeRef record) {
        NodeRef parent = this.nodeService.getPrimaryParent(record).getParentRef();
        return this.getVitalRecordDefinition(parent);
    }

    @Override
    public VitalRecordDefinition setVitalRecordDefintion(NodeRef nodeRef, boolean enabled, Period reviewPeriod) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"enabled", (Object)enabled);
        this.nodeService.setProperty(nodeRef, PROP_VITAL_RECORD_INDICATOR, (Serializable)Boolean.valueOf(enabled));
        this.nodeService.setProperty(nodeRef, PROP_REVIEW_PERIOD, (Serializable)reviewPeriod);
        return new VitalRecordDefinitionImpl(enabled, reviewPeriod);
    }

    @Override
    public boolean isVitalRecord(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ASPECT_VITAL_RECORD);
    }
}

