/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v22;

import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.patch.AbstractModulePatch;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;

public class RMv22RemoveInPlaceRolesFromAllPatch
extends AbstractModulePatch {
    private FilePlanService filePlanService;
    private FilePlanRoleService filePlanRoleService;
    private AuthorityService authorityService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    @Override
    public void applyInternal() {
        Set<NodeRef> filePlans = this.filePlanService.getFilePlans();
        for (NodeRef filePlan : filePlans) {
            Role extendedReaders = this.filePlanRoleService.getRole(filePlan, "ExtendedReaders");
            Role extendedWriters = this.filePlanRoleService.getRole(filePlan, "ExtendedWriters");
            String allRolesGroup = this.filePlanRoleService.getAllRolesContainerGroup(filePlan);
            Set members = this.authorityService.getContainedAuthorities(null, allRolesGroup, true);
            if (members.contains(extendedReaders.getRoleGroupName())) {
                this.authorityService.removeAuthority(allRolesGroup, extendedReaders.getRoleGroupName());
            }
            if (!members.contains(extendedWriters.getRoleGroupName())) continue;
            this.authorityService.removeAuthority(allRolesGroup, extendedWriters.getRoleGroupName());
        }
    }
}

