/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public final class WebScriptUtils {
    private WebScriptUtils() {
    }

    public static Map<String, String> getTemplateVars(WebScriptRequest req) {
        ParameterCheck.mandatory((String)"req", (Object)req);
        if (req.getServiceMatch() == null) {
            throw new WebScriptException(400, "The matching API Service for the request is null.");
        }
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars == null) {
            throw new WebScriptException(400, "The template variable substitutions map is null");
        }
        return templateVars;
    }

    public static String getRequestParameterValue(WebScriptRequest req, String parameter) {
        ParameterCheck.mandatory((String)"req", (Object)req);
        ParameterCheck.mandatoryString((String)"parameter", (String)parameter);
        return WebScriptUtils.getRequestParameterValue(req, parameter, true);
    }

    public static String getRequestParameterValue(WebScriptRequest req, String parameter, boolean checkValue) {
        ParameterCheck.mandatory((String)"req", (Object)req);
        ParameterCheck.mandatoryString((String)"parameter", (String)parameter);
        Map<String, String> templateVars = WebScriptUtils.getTemplateVars(req);
        String value = templateVars.get(parameter);
        if (checkValue && StringUtils.isBlank((CharSequence)value)) {
            throw new WebScriptException(404, "The value for the parameter '" + parameter + "' is blank.");
        }
        return value;
    }

    public static JSONObject getRequestContentAsJSONObject(WebScriptRequest req) {
        JSONObject json;
        String content;
        ParameterCheck.mandatory((String)"req", (Object)req);
        Content reqContent = req.getContent();
        if (reqContent == null) {
            throw new WebScriptException(400, "Missing request body.");
        }
        try {
            content = reqContent.getContent();
        }
        catch (IOException error) {
            throw new WebScriptException(400, "Could not get content from the request.", (Throwable)error);
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new WebScriptException(400, "Content does not exist.");
        }
        JSONTokener jsonTokener = new JSONTokener(content);
        try {
            json = new JSONObject(jsonTokener);
        }
        catch (JSONException error) {
            throw new WebScriptException(400, "Unable to parse request body.", (Throwable)error);
        }
        return json;
    }

    public static void checkMandatoryJSONParam(JSONObject jsonObject, String paramName) {
        ParameterCheck.mandatory((String)"jsonObject", (Object)jsonObject);
        ParameterCheck.mandatoryString((String)"paramName", (String)paramName);
        if (!jsonObject.has(paramName)) {
            throw new WebScriptException(400, "The json object does not contain an entry with parameter '" + paramName + "'.");
        }
    }

    public static void checkMandatoryJSONParams(JSONObject jsonObject, List<String> paramNames) {
        ParameterCheck.mandatory((String)"jsonObject", (Object)jsonObject);
        ParameterCheck.mandatory((String)"paramNames", paramNames);
        for (String name : paramNames) {
            WebScriptUtils.checkMandatoryJSONParam(jsonObject, name);
        }
    }

    public static String getStringValueFromJSONObject(JSONObject jsonObject, String key) {
        ParameterCheck.mandatory((String)"jsonObject", (Object)jsonObject);
        ParameterCheck.mandatoryString((String)"key", (String)key);
        return WebScriptUtils.getStringValueFromJSONObject(jsonObject, key, true, true);
    }

    public static String getStringValueFromJSONObject(JSONObject jsonObject, String key, boolean checkKey, boolean checkValue) {
        String value;
        block4: {
            ParameterCheck.mandatory((String)"jsonObject", (Object)jsonObject);
            ParameterCheck.mandatoryString((String)"key", (String)key);
            if (checkKey) {
                WebScriptUtils.checkMandatoryJSONParam(jsonObject, key);
            }
            value = null;
            try {
                value = jsonObject.get(key).toString();
                if (checkValue && StringUtils.isBlank((CharSequence)value)) {
                    throw new WebScriptException(400, "The value is missing for the key '" + key + "'.");
                }
            }
            catch (JSONException error) {
                if (!checkValue) break block4;
                throw new WebScriptException(400, "Could not get value for the key '" + key + "'.", (Throwable)error);
            }
        }
        return value;
    }

    public static void putValueToJSONObject(JSONObject jsonObject, String key, Object value) {
        ParameterCheck.mandatory((String)"jsonObject", (Object)jsonObject);
        ParameterCheck.mandatoryString((String)"key", (String)key);
        ParameterCheck.mandatory((String)"value", (Object)value);
        try {
            jsonObject.put(key, value);
        }
        catch (JSONException error) {
            throw new WebScriptException(400, "Could not put the key '" + key + "' with the value '" + String.valueOf(value) + "' to the json object.", (Throwable)error);
        }
    }

    public static Object getJSONArrayValue(JSONArray jsonArray, int index) {
        Object value;
        ParameterCheck.mandatory((String)"jsonArray", (Object)jsonArray);
        try {
            value = jsonArray.get(index);
        }
        catch (JSONException error) {
            throw new WebScriptException(400, "Could not get value for the index '" + index + "' from the JSON Array.", (Throwable)error);
        }
        return value;
    }

    public static JSONObject createJSONObject(String json) {
        JSONObject jsonObject;
        ParameterCheck.mandatory((String)"json", (Object)json);
        try {
            jsonObject = new JSONObject(json);
        }
        catch (JSONException error) {
            throw new WebScriptException(400, "Cannot create a json object from the given string '" + json + "'.", (Throwable)error);
        }
        return jsonObject;
    }

    public static JSONArray createJSONArray(String json) {
        JSONArray jsonArray;
        ParameterCheck.mandatory((String)"json", (Object)json);
        try {
            jsonArray = new JSONArray(json);
        }
        catch (JSONException error) {
            throw new WebScriptException(400, "Cannot create a json array from the given string '" + json + "'.", (Throwable)error);
        }
        return jsonArray;
    }

    public static JSONArray getJSONArrayFromJSONObject(JSONObject jsonObject, String key) {
        JSONArray jsonArray;
        ParameterCheck.mandatory((String)"jsonObject", (Object)jsonObject);
        ParameterCheck.mandatory((String)"key", (Object)key);
        try {
            jsonArray = jsonObject.getJSONArray(key);
        }
        catch (JSONException error) {
            throw new WebScriptException(400, "Could not get the json array for the key '" + key + "'.", (Throwable)error);
        }
        return jsonArray;
    }

    public static boolean is4xxError(WebScriptException e) {
        return WebScriptUtils.isStatusInRange(e, 400, 500);
    }

    public static boolean is5xxError(WebScriptException e) {
        return WebScriptUtils.isStatusInRange(e, 500, 600);
    }

    private static boolean isStatusInRange(WebScriptException e, int lowerLimitInclusive, int upperLimitExclusive) {
        int status = e.getStatus();
        return status >= lowerLimitInclusive && status < upperLimitExclusive;
    }

    public static JSONObject getValueFromJSONObject(JSONObject jsonObject, String key) {
        ParameterCheck.mandatory((String)"jsonObject", (Object)jsonObject);
        ParameterCheck.mandatoryString((String)"key", (String)key);
        JSONObject value = null;
        try {
            value = jsonObject.getJSONObject(key);
        }
        catch (JSONException error) {
            throw new WebScriptException(400, "Could not get value for the key '" + key + "'.", (Throwable)error);
        }
        return value;
    }
}

