/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.transfers;

import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.query.PagingResults;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.impl.SearchTypesFactory;
import org.alfresco.rm.rest.api.model.Transfer;
import org.alfresco.rm.rest.api.model.TransferChild;
import org.alfresco.rm.rest.api.transfers.TransferEntityResource;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;

@RelationshipResource(name="children", entityResource=TransferEntityResource.class, title="Children of a transfer")
public class TransferChildrenRelation
implements RelationshipResourceAction.Read<TransferChild> {
    private FilePlanComponentsApiUtils apiUtils;
    private SearchTypesFactory searchTypesFactory;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setSearchTypesFactory(SearchTypesFactory searchTypesFactory) {
        this.searchTypesFactory = searchTypesFactory;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    @WebApiDescription(title="Return a paged list of record folders or records for the transfer identified by 'transferId'")
    public CollectionWithPagingInfo<TransferChild> readAll(String transferId, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("transferId", transferId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateNodeType(transferId, RecordsManagementModel.TYPE_TRANSFER);
        PagingResults pagingResults = this.fileFolderService.list(parentNodeRef, null, null, null, this.apiUtils.getSortProperties(parameters), null, Util.getPagingRequest((Paging)parameters.getPaging()));
        final List page = pagingResults.getPage();
        final HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        AbstractList<TransferChild> nodes = new AbstractList<TransferChild>(){

            @Override
            public TransferChild get(int index) {
                FileInfo info = (FileInfo)page.get(index);
                return TransferChildrenRelation.this.nodesModelFactory.createTransferChild(info, parameters, mapUserInfo, true);
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        Transfer sourceEntity = null;
        if (parameters.includeSource()) {
            FileInfo info = this.fileFolderService.getFileInfo(parentNodeRef);
            sourceEntity = this.nodesModelFactory.createTransfer(info, parameters, mapUserInfo, true);
        }
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)nodes, (boolean)pagingResults.hasMoreItems(), (Integer)((Integer)pagingResults.getTotalResultCount().getFirst()), sourceEntity);
    }
}

