/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.UnfiledRecordContainerType;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;

public class UnfiledRecordContainerTypeUnitTest
extends BaseUnitTest {
    @InjectMocks
    private UnfiledRecordContainerType unfiledRecordContainerType;

    @Test(expected=IntegrityException.class)
    public void testAddNonAcceptedTypeToUnfiledRecordContainer() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_UNFILED_RECORD_FOLDER)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, ContentModel.TYPE_CONTENT)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_NON_ELECTRONIC_DOCUMENT)).thenReturn((Object)false);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef unfiledRecordContainer = this.generateNodeRef(TYPE_UNFILED_RECORD_CONTAINER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)unfiledRecordContainer);
        this.unfiledRecordContainerType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddUnfiledRecordFolderTypeToUnfiledRecordContainer() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_UNFILED_RECORD_FOLDER)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, ContentModel.TYPE_CONTENT)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_NON_ELECTRONIC_DOCUMENT)).thenReturn((Object)false);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef unfiledRecordContainer = this.generateNodeRef(TYPE_UNFILED_RECORD_CONTAINER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)unfiledRecordContainer);
        this.unfiledRecordContainerType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testAddContentTypeToUnfiledRecordContainer() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_UNFILED_RECORD_FOLDER)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, ContentModel.TYPE_CONTENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_NON_ELECTRONIC_DOCUMENT)).thenReturn((Object)false);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef unfiledRecordContainer = this.generateNodeRef(TYPE_UNFILED_RECORD_CONTAINER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)unfiledRecordContainer);
        this.unfiledRecordContainerType.onCreateChildAssociation(mockedChildAssoc, true);
    }

    @Test
    public void testNonElectronicDocumentTypeToUnfiledRecordContainer() {
        QName type = AlfMock.generateQName();
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_UNFILED_RECORD_FOLDER)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, ContentModel.TYPE_CONTENT)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeTypeUtility.instanceOf(type, TYPE_NON_ELECTRONIC_DOCUMENT)).thenReturn((Object)true);
        NodeRef nodeRef = AlfMock.generateNodeRef(this.mockedNodeService, type);
        NodeRef unfiledRecordContainer = this.generateNodeRef(TYPE_UNFILED_RECORD_CONTAINER, true);
        ChildAssociationRef mockedChildAssoc = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)mockedChildAssoc.getChildRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)mockedChildAssoc.getParentRef()).thenReturn((Object)unfiledRecordContainer);
        this.unfiledRecordContainerType.onCreateChildAssociation(mockedChildAssoc, true);
    }
}

