/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v32;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.v32.RMv32HoldChildAssocPatch;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class RMv32HoldChildAssocPatchUnitTest {
    @Mock
    private QNameDAO qNameDAO;
    @Mock
    private NodeService nodeService;
    @Mock
    private FilePlanService filePlanService;
    @Mock
    private HoldService holdService;
    @InjectMocks
    private RMv32HoldChildAssocPatch patch;
    private NodeRef filePlanRef;
    private NodeRef holdRef;
    private NodeRef heldItemRef;
    private Set<NodeRef> fileplans;
    private List<NodeRef> holds;
    @Mock
    private ChildAssociationRef childAssociationRef;
    private List<ChildAssociationRef> childAssocs;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.filePlanRef = new NodeRef("workspace://SpacesStore/filePlan");
        this.holdRef = new NodeRef("workspace://SpacesStore/hold");
        this.heldItemRef = new NodeRef("workspace://SpacesStore/heldItem");
        this.fileplans = new HashSet<NodeRef>();
        this.fileplans.add(this.filePlanRef);
        this.holds = new ArrayList<NodeRef>();
        this.holds.add(this.holdRef);
        this.childAssocs = new ArrayList<ChildAssociationRef>();
        this.childAssocs.add(this.childAssociationRef);
    }

    @Test
    public void testAHoldIsRemovedAndReplacedDuringUpgrade() {
        Mockito.when((Object)this.qNameDAO.getQName(RecordsManagementModel.ASSOC_FROZEN_RECORDS)).thenReturn((Object)new Pair((Object)RecordsManagementModel.ASSOC_FROZEN_CONTENT, null));
        Mockito.when((Object)this.filePlanService.getFilePlans()).thenReturn(this.fileplans);
        Mockito.when((Object)this.holdService.getHolds(this.filePlanRef)).thenReturn(this.holds);
        Mockito.when((Object)this.nodeService.getChildAssocs(this.holdRef, (QNamePattern)RecordsManagementModel.ASSOC_FROZEN_CONTENT, (QNamePattern)RecordsManagementModel.ASSOC_FROZEN_RECORDS)).thenReturn(this.childAssocs);
        Mockito.when((Object)this.childAssociationRef.getChildRef()).thenReturn((Object)this.heldItemRef);
        this.patch.applyInternal();
        ((HoldService)Mockito.verify((Object)this.holdService, (VerificationMode)Mockito.times((int)1))).removeFromHold(this.holdRef, this.heldItemRef);
        ((HoldService)Mockito.verify((Object)this.holdService, (VerificationMode)Mockito.times((int)1))).addToHold(this.holdRef, this.heldItemRef);
    }

    @Test
    public void testAHoldIsntRemovedAndReplacedDuringUpgradeWithNoRmSite() {
        Mockito.when((Object)this.qNameDAO.getQName(RecordsManagementModel.ASSOC_FROZEN_RECORDS)).thenReturn(null);
        this.patch.applyInternal();
        ((QNameDAO)Mockito.verify((Object)this.qNameDAO, (VerificationMode)Mockito.never())).updateQName(RecordsManagementModel.ASSOC_FROZEN_RECORDS, RecordsManagementModel.ASSOC_FROZEN_CONTENT);
    }
}

