/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue.rm3314;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.test.integration.issue.rm3314.RM3314Test;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.jdbc.BadSqlGrammarException;

public class RM3314TestListener
implements ApplicationListener<ContextRefreshedEvent>,
Ordered,
BeanNameAware {
    private RecordsManagementAdminServiceImpl recordsManagementAdminService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private Repository repository;
    private String name;
    private int order = Integer.MAX_VALUE;

    public void setRecordsManagementAdminService(RecordsManagementAdminServiceImpl recordsManagementAdminService) {
        this.recordsManagementAdminService = recordsManagementAdminService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        RM3314Test.callback.put(this.name, this.recordsManagementAdminService.isCustomMapInit());
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                block5: {
                    try {
                        NodeRef companyHome = RM3314TestListener.this.repository.getCompanyHome();
                        if (RM3314TestListener.this.fileFolderService.searchSimple(companyHome, RM3314TestListener.this.name) != null) break block5;
                        NodeRef folder = RM3314TestListener.this.fileFolderService.create(RM3314TestListener.this.repository.getCompanyHome(), RM3314TestListener.this.name, ContentModel.TYPE_FOLDER).getNodeRef();
                        try {
                            RM3314TestListener.this.nodeService.addAspect(folder, ContentModel.ASPECT_CLASSIFIABLE, null);
                            RM3314TestListener.this.nodeService.removeAspect(folder, ContentModel.ASPECT_CLASSIFIABLE);
                        }
                        finally {
                            RM3314TestListener.this.nodeService.deleteNode(folder);
                        }
                    }
                    catch (BadSqlGrammarException badSqlGrammarException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    public int getOrder() {
        return this.order;
    }
}

