/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.bdt.BehaviourTest;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.GUID;

public class InplaceRecordPermissionTest
extends BaseRMTestCase {
    private static final List<String> CAPABILITIES = Stream.of("ViewRecords", "EditNonRecordMetadata", "EditRecordMetadata").collect(Collectors.toList());
    private NodeRef contribDoc;
    private NodeRef deleteUserDoc;
    private NodeRef copiedDoc;
    private NodeRef copyDoc;
    private String deletedUser;
    private NodeService dbNodeService;
    private Capability viewRecordsCapability;
    private Capability editNonRecordMetadataCapability;
    private Capability editRecordMetadataCapability;

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void initServices() {
        super.initServices();
        BehaviourTest.initBehaviourTests(this.retryingTransactionHelper);
        this.dbNodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.viewRecordsCapability = this.capabilityService.getCapability("ViewRecords");
        this.editNonRecordMetadataCapability = this.capabilityService.getCapability("EditNonRecordMetadata");
        this.editRecordMetadataCapability = this.capabilityService.getCapability("EditRecordMetadata");
    }

    public void testUserWithOutWriteCantDeclareInPlaceRecord() {
        BehaviourTest.test().given().expect(false).from(() -> this.recordService.isRecord(this.dmDocument)).because("The document is not a record.").as(this.userName).expect(AccessStatus.DENIED.toString()).from(() -> this.permissionService.hasPermission(this.dmDocument, "Write").toString()).because("User does not have write access to document.").when().as(this.userName).expectException(AccessDeniedException.class).from(() -> this.recordService.createRecord(this.filePlan, this.dmDocument)).because("The user does not have write permission on the document.");
    }

    public void testContributorThatIsntOwnerDeclareInPlaceRecord() {
        BehaviourTest.test().given().expect(false).from(() -> this.recordService.isRecord(this.dmDocument)).because("The document is not a record.").as(this.dmContributor).expect(AccessStatus.DENIED.toString()).from(() -> this.permissionService.hasPermission(this.dmDocument, "Write").toString()).because("Contributor does not have write access to document.").when().as(this.dmContributor).expectException(AccessDeniedException.class).from(() -> this.recordService.createRecord(this.filePlan, this.dmDocument)).because("The contributor does not have write permission on the document.");
    }

    public void testCreateInplaceRecordFromCollabSite() {
        BehaviourTest.test().given().asAdmin().expect(false).from(() -> this.recordService.isRecord(this.dmDocument)).because("The document is not a record").when().as(this.dmCollaborator).perform(() -> this.recordService.createRecord(this.filePlan, this.dmDocument)).then().asAdmin().expect(true).from(() -> this.recordService.isRecord(this.dmDocument)).because("The document is a record").expect(false).from(() -> this.recordService.isFiled(this.dmDocument)).because("The record is not filed").as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED)).as(this.dmContributor).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmConsumer).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.userName).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED));
    }

    private void checkInPlaceAccess(NodeRef nodeRef, AccessStatus ... accessStatus) {
        InplaceRecordPermissionTest.assertEquals((String)"Incorrect read record permission access.", (Object)accessStatus[0], (Object)this.permissionService.hasPermission(nodeRef, "ReadRecords"));
        InplaceRecordPermissionTest.assertEquals((String)"Incorrect filling permission access.", (Object)accessStatus[1], (Object)this.permissionService.hasPermission(nodeRef, "Filing"));
        Map access = this.capabilityService.getCapabilitiesAccessState(nodeRef, CAPABILITIES);
        InplaceRecordPermissionTest.assertEquals((String)"Incorrect view records capability access", (Object)accessStatus[2], access.get(this.viewRecordsCapability));
        InplaceRecordPermissionTest.assertEquals((String)"Incorrect edit non record metadata capability access", (Object)accessStatus[3], access.get(this.editNonRecordMetadataCapability));
        InplaceRecordPermissionTest.assertEquals((String)"Incorrect edit record metadata capability access", (Object)accessStatus[4], access.get(this.editRecordMetadataCapability));
    }

    public void testCreateInplaceRecordFromCollabSiteWhenContribIsCreatorOfDocument() {
        BehaviourTest.test().given().as(this.dmContributor).perform(() -> {
            this.contribDoc = this.fileFolderService.create(this.dmFolder, "contrib.txt", ContentModel.TYPE_CONTENT).getNodeRef();
            this.dbNodeService.addAspect(this.contribDoc, ContentModel.ASPECT_AUDITABLE, null);
        }).expect(false).from(() -> this.recordService.isRecord(this.contribDoc)).because("It is not a record.").asAdmin().expect(this.dmContributor).from(() -> this.ownableService.getOwner(this.contribDoc)).because("As the creator of the document the contributor is also the owner").as(this.dmContributor).expect(AccessStatus.ALLOWED.toString()).from(() -> this.permissionService.hasPermission(this.contribDoc, "Write").toString()).because("Contrib user has write permissions on created document as the owner.").when().as(this.dmContributor).perform(() -> this.recordService.createRecord(this.filePlan, this.contribDoc)).then().asAdmin().expect(true).from(() -> this.recordService.isRecord(this.contribDoc)).because("The document is a record").expect(false).from(() -> this.recordService.isFiled(this.contribDoc)).because("The record is not filed").as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.contribDoc, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED)).as(this.dmContributor).perform(() -> this.checkInPlaceAccess(this.contribDoc, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED)).as(this.dmConsumer).perform(() -> this.checkInPlaceAccess(this.contribDoc, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.userName).perform(() -> this.checkInPlaceAccess(this.contribDoc, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED));
    }

    public void testFileInplaceRecordFromCollabSite() throws Exception {
        BehaviourTest.test().given().as(this.dmCollaborator).perform(() -> this.recordService.createRecord(this.filePlan, this.dmDocument)).expect(true).from(() -> this.recordService.isRecord(this.dmDocument)).because("The document is a record.").expect(false).from(() -> this.recordService.isFiled(this.dmDocument)).because("The record is not filed").when().asAdmin().perform(() -> this.fileFolderService.move(this.dmDocument, this.rmFolder, null)).then().asAdmin().expect(true).from(() -> this.recordService.isFiled(this.dmDocument)).because("The record is filed.").as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED)).as(this.dmContributor).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmConsumer).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.userName).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED));
    }

    public void testCompletedInPlaceRecord() {
        BehaviourTest.test().given().as(this.dmCollaborator).perform(() -> this.recordService.createRecord(this.filePlan, this.dmDocument)).expect(false).from(() -> this.recordService.isDeclared(this.dmDocument)).because("Record is not complete.").when().asAdmin().perform(() -> this.rmActionService.executeRecordsManagementAction(this.dmDocument, "declareRecord")).expect(true).from(() -> this.recordService.isDeclared(this.dmDocument)).because("Record is complete.").then().as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmContributor).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmConsumer).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.ALLOWED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.userName).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED));
    }

    public void testDestroyedRecordInplacePermissions() {
        BehaviourTest.test().given().as(this.dmCollaborator).perform(() -> this.recordService.createRecord(this.filePlan, this.dmDocument)).expect(true).from(() -> this.recordService.isRecord(this.dmDocument)).because("Document is a record.").asAdmin().perform(() -> {
            NodeRef recordCategory = this.filePlanService.createRecordCategory(this.filePlan, GUID.generate());
            this.utils.createBasicDispositionSchedule(recordCategory, GUID.generate(), GUID.generate(), true, true);
            NodeRef recordFolder = this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
            this.fileFolderService.move(this.dmDocument, recordFolder, null);
            this.rmActionService.executeRecordsManagementAction(this.dmDocument, "declareRecord");
            this.utils.completeEvent(this.dmDocument, "case_closed");
            this.rmActionService.executeRecordsManagementAction(this.dmDocument, "cutoff");
        }).expect("destroy").from(() -> this.dispositionService.getNextDispositionAction(this.dmDocument).getName()).because("The next action is destroy.").expect(true).from(() -> this.dispositionService.isNextDispositionActionEligible(this.dmDocument)).because("The next action is eligible.").when(() -> this.rmActionService.executeRecordsManagementAction(this.dmDocument, "destroy")).then().expect(true).from(() -> this.recordService.isMetadataStub(this.dmDocument)).because("The record has been destroyed and the meta-stub remains.").as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmContributor).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmConsumer).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.userName).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED));
    }

    public void testAddUserToRole() {
        BehaviourTest.test().given().as(this.dmCollaborator).perform(() -> this.recordService.createRecord(this.filePlan, this.dmDocument)).expect(true).from(() -> this.recordService.isRecord(this.dmDocument)).because("Document is a record.").perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED)).when().asAdmin().perform(() -> this.filePlanRoleService.updateRole(this.filePlan, "ExtendedWriters", "", Stream.of(this.viewRecordsCapability, this.editNonRecordMetadataCapability, this.editRecordMetadataCapability).collect(Collectors.toSet()))).then().as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED));
    }

    public void testNoPermissionsAfterHide() {
        BehaviourTest.test().given().as(this.dmCollaborator).perform(() -> this.recordService.createRecord(this.filePlan, this.dmDocument)).expect(true).from(() -> this.recordService.isRecord(this.dmDocument)).because("Document is a record.").when().asAdmin().perform(() -> this.inplaceRecordService.hideRecord(this.dmDocument)).then().as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmContributor).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmConsumer).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.userName).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED));
    }

    public void testNoPermissionsAfterReject() {
        BehaviourTest.test().given().as(this.dmCollaborator).perform(() -> this.recordService.createRecord(this.filePlan, this.dmDocument)).expect(true).from(() -> this.recordService.isRecord(this.dmDocument)).because("Document is a record.").when().asAdmin().perform(() -> this.recordService.rejectRecord(this.dmDocument, GUID.generate())).then().as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmContributor).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmConsumer).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.userName).perform(() -> this.checkInPlaceAccess(this.dmDocument, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED));
    }

    public void testCmCreatorDeletedBeforeRecordDeclaration() {
        BehaviourTest.test().given().asAdmin().perform(() -> {
            this.deletedUser = GUID.generate();
            this.createPerson(this.deletedUser);
            this.siteService.setMembership(this.collabSiteId, this.deletedUser, "SiteContributor");
        }).as(this.deletedUser).perform(() -> {
            this.deleteUserDoc = this.fileFolderService.create(this.dmFolder, "deleteUserDoc.txt", ContentModel.TYPE_CONTENT).getNodeRef();
            this.dbNodeService.addAspect(this.deleteUserDoc, ContentModel.ASPECT_AUDITABLE, null);
        }).asAdmin().perform(() -> this.personService.deletePerson(this.deletedUser)).when().as(this.dmCollaborator).perform(() -> this.recordService.createRecord(this.filePlan, this.deleteUserDoc)).then().expect(true).from(() -> this.recordService.isRecord(this.deleteUserDoc)).because("The document is now a record.");
    }

    public void testNoPermissionsOnCopy() {
        BehaviourTest.test().given().as(this.dmCollaborator).perform(() -> {
            this.copiedDoc = this.fileFolderService.create(this.dmFolder, "copiedDoc.txt", ContentModel.TYPE_CONTENT).getNodeRef();
            this.dbNodeService.addAspect(this.copiedDoc, ContentModel.ASPECT_AUDITABLE, null);
            this.recordService.createRecord(this.filePlan, this.copiedDoc);
        }).asAdmin().perform(() -> this.fileFolderService.move(this.copiedDoc, this.rmFolder, null)).as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.copiedDoc, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED)).when().asAdmin().perform(() -> {
            this.copyDoc = this.fileFolderService.copy(this.copiedDoc, this.rmFolder, "newRecord.txt").getNodeRef();
        }).then().as(this.dmCollaborator).perform(() -> this.checkInPlaceAccess(this.copyDoc, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).perform(() -> this.checkInPlaceAccess(this.copiedDoc, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.ALLOWED, AccessStatus.DENIED)).as(this.dmContributor).perform(() -> this.checkInPlaceAccess(this.copyDoc, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.dmConsumer).perform(() -> this.checkInPlaceAccess(this.copyDoc, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED)).as(this.userName).perform(() -> this.checkInPlaceAccess(this.copyDoc, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED, AccessStatus.DENIED));
    }

    public void testGroupReuse() {
        BehaviourTest.test().when().as(this.dmCollaborator).perform(50, () -> {
            NodeRef newDocument = this.fileFolderService.create(this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
            this.recordService.createRecord(this.filePlan, newDocument);
        }).as(this.dmContributor).perform(50, () -> {
            NodeRef newDocument = this.fileFolderService.create(this.dmFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
            this.recordService.createRecord(this.filePlan, newDocument);
        }).then().asAdmin().expect(101).from(() -> this.nodeService.getChildAssocs(this.dmFolder).size()).because("One hundred inplace records have been created.").expect(3).from(() -> this.authorityService.getContainedAuthorities(null, "GROUP_INPLACE_RECORD_MANAGEMENT", true).size()).because("The read and write groups are reused.");
    }

    @Override
    protected void tearDownImpl() {
        super.tearDownImpl();
        this.authorityService.getContainedAuthorities(null, "GROUP_INPLACE_RECORD_MANAGEMENT", true).stream().forEach(group -> this.authorityService.deleteAuthority(group));
    }
}

