/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.report.Report;
import org.alfresco.module.org_alfresco_module_rm.report.ReportModel;
import org.alfresco.module.org_alfresco_module_rm.report.ReportService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public class FileReportAction
extends RMActionExecuterAbstractBase
implements ReportModel {
    public static final String NAME = "fileReport";
    public static final String REPORT_TYPE = "reportType";
    public static final String DESTINATION = "destination";
    public static final String MIMETYPE = "mimetype";
    private static final String MSG_PARAM_NOT_SUPPLIED = "rm.action.parameter-not-supplied";
    private ReportService reportService;
    private CapabilityService capabilityService;

    protected ReportService getReportService() {
        return this.reportService;
    }

    protected CapabilityService getCapabilityService() {
        return this.capabilityService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        String mimetype = (String)((Object)action.getParameterValue(MIMETYPE));
        if (mimetype == null || mimetype.isEmpty()) {
            mimetype = "text/html";
        }
        QName reportType = this.getReportType(action);
        final NodeRef destination = this.getDestination(action);
        this.checkFilingPermissionOnlyCapability(destination);
        final Report report = this.getReportService().generateReport(reportType, actionedUponNodeRef, mimetype);
        NodeRef filedReport = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() {
                return FileReportAction.this.getReportService().fileReport(destination, report);
            }
        });
        String filedReportName = (String)((Object)this.getNodeService().getProperty(filedReport, ContentModel.PROP_NAME));
        action.setParameterValue("result", (Serializable)((Object)filedReportName));
    }

    private void checkFilingPermissionOnlyCapability(NodeRef nodeRef) {
        if (AccessStatus.DENIED.equals((Object)this.capabilityService.getCapability("FillingPermissionOnly").hasPermission(nodeRef))) {
            throw new AlfrescoRuntimeException("You don't have filing permission on the destination or the destination is either frozen, closed or cut off!");
        }
    }

    private String getParameterValue(Action action, String parameter) {
        String paramValue = (String)((Object)action.getParameterValue(parameter));
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_PARAM_NOT_SUPPLIED, (Object[])new Object[]{parameter}));
        }
        return paramValue;
    }

    private NodeRef getDestination(Action action) {
        String destination = this.getParameterValue(action, DESTINATION);
        return new NodeRef(destination);
    }

    private QName getReportType(Action action) {
        String reportType = this.getParameterValue(action, REPORT_TYPE);
        return QName.createQName((String)reportType, (NamespacePrefixResolver)this.getNamespaceService());
    }
}

