/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.Group;
import org.alfresco.module.org_alfresco_module_rm.capability.GroupImpl;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class CapabilityServiceImplTest
extends BaseRMTestCase {
    public void testGetAddRemoveGroups() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                Group auditGroup = CapabilityServiceImplTest.this.capabilityService.getGroup("audit");
                TestCase.assertNotNull((Object)auditGroup);
                TestCase.assertEquals((int)10, (int)auditGroup.getIndex());
                TestCase.assertEquals((String)"Audit", (String)auditGroup.getTitle());
                TestCase.assertEquals((String)"audit", (String)auditGroup.getId());
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                int initialSize = CapabilityServiceImplTest.this.capabilityService.getGroups().size();
                GroupImpl testGroup = new GroupImpl();
                testGroup.setId("testGroup");
                testGroup.setIndex(140);
                testGroup.setTitle("Test group");
                CapabilityServiceImplTest.this.capabilityService.addGroup((Group)testGroup);
                TestCase.assertEquals((int)(initialSize + 1), (int)CapabilityServiceImplTest.this.capabilityService.getGroups().size());
                Group group = CapabilityServiceImplTest.this.capabilityService.getGroup("testGroup");
                TestCase.assertNotNull((Object)group);
                TestCase.assertTrue((boolean)group.getId().equalsIgnoreCase("testGroup"));
                TestCase.assertTrue((boolean)group.getTitle().equalsIgnoreCase("Test group"));
                TestCase.assertTrue((group.getIndex() == 140 ? 1 : 0) != 0);
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                Group testGroup = CapabilityServiceImplTest.this.capabilityService.getGroup("testGroup");
                TestCase.assertNotNull((Object)testGroup);
                int initialSize = CapabilityServiceImplTest.this.capabilityService.getGroups().size();
                CapabilityServiceImplTest.this.capabilityService.removeGroup(testGroup);
                TestCase.assertEquals((int)(initialSize - 1), (int)CapabilityServiceImplTest.this.capabilityService.getGroups().size());
                return null;
            }
        });
    }

    public void testGetCapabilitiesByGroup() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                List groups = CapabilityServiceImplTest.this.capabilityService.getGroups();
                TestCase.assertNotNull((Object)groups);
                Group recordsGroup = (Group)groups.get(0);
                TestCase.assertNotNull((Object)recordsGroup);
                List recordCapabilities = CapabilityServiceImplTest.this.capabilityService.getCapabilitiesByGroup(recordsGroup);
                TestCase.assertNotNull((Object)recordCapabilities);
                int recordCapabilitiesSize = recordCapabilities.size();
                TestCase.assertTrue((recordCapabilitiesSize > 1 ? 1 : 0) != 0);
                for (int i = 1; i == recordCapabilitiesSize; ++i) {
                    Capability capability = (Capability)recordCapabilities.get(i);
                    TestCase.assertNotNull((Object)capability);
                    TestCase.assertEquals((int)(i * 10), (int)capability.getIndex());
                }
                Group rulesGroup = (Group)groups.get(groups.size() - 2);
                TestCase.assertNotNull((Object)rulesGroup);
                List ruleCapabilities = CapabilityServiceImplTest.this.capabilityService.getCapabilitiesByGroupId(rulesGroup.getId());
                TestCase.assertNotNull((Object)ruleCapabilities);
                int ruleCapabilitiesSize = ruleCapabilities.size();
                TestCase.assertTrue((ruleCapabilitiesSize > 0 ? 1 : 0) != 0);
                return null;
            }
        });
    }
}

