/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v20;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.compatibility.ModulePatchComponent;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchService;
import org.alfresco.module.org_alfresco_module_rm.search.SavedSearchDetails;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteService;
import org.springframework.beans.factory.BeanNameAware;

public class RMv2SavedSearchPatch
extends ModulePatchComponent
implements BeanNameAware,
RecordsManagementModel,
DOD5015Model {
    private RecordsManagementSearchService recordsManagementSearchService;
    private SiteService siteService;
    private ContentService contentService;

    public void setRecordsManagementSearchService(RecordsManagementSearchService recordsManagementSearchService) {
        this.recordsManagementSearchService = recordsManagementSearchService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    protected void executePatch() {
        if (this.siteService.getSite("rm") != null) {
            List<SavedSearchDetails> savedSearches = this.recordsManagementSearchService.getSavedSearches("rm");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  ... updating " + savedSearches.size() + " saved searches");
            }
            for (SavedSearchDetails savedSearchDetails : savedSearches) {
                String refreshedJSON = savedSearchDetails.toJSONString();
                NodeRef nodeRef = savedSearchDetails.getNodeRef();
                if (nodeRef == null) continue;
                ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.putContent(refreshedJSON);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("    ... updated saved search " + savedSearchDetails.getName() + " (nodeRef=" + nodeRef.toString() + ")");
            }
        }
    }
}

