/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.transfer;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.TransferContainerType;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.TransferType;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.transfer.TransferService;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

public class TransferServiceImpl
extends ServiceBaseImpl
implements TransferService,
RecordsManagementModel {
    public static final String KEY_TRANSFER_NODEREF = "transferNodeRef";
    private static final String MSG_NODE_ALREADY_TRANSFER = "rm.action.node-already-transfer";
    protected FilePlanService filePlanService;
    protected DispositionService dispositionService;
    protected RecordService recordService;
    protected RecordFolderService recordFolderService;
    protected FreezeService freezeService;
    protected TransferContainerType transferContainerType;
    protected TransferType transferType;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setFreezeService(FreezeService freezeService) {
        this.freezeService = freezeService;
    }

    public void setTransferContainerType(TransferContainerType transferContainerType) {
        this.transferContainerType = transferContainerType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef transfer(NodeRef nodeRef, boolean isAccession) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        NodeRef root = this.filePlanService.getFilePlan(nodeRef);
        NodeRef transferNodeRef = (NodeRef)AlfrescoTransactionSupport.getResource((Object)KEY_TRANSFER_NODEREF);
        if (transferNodeRef == null) {
            DispositionActionDefinition actionDef;
            QName nodeDbid = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"node-dbid");
            Long dbId = (Long)this.nodeService.getProperty(nodeRef, nodeDbid);
            String transferName = StringUtils.leftPad((String)dbId.toString(), (int)10, (String)"0");
            HashMap<QName, Object> transferProps = new HashMap<QName, Object>(2);
            transferProps.put(ContentModel.PROP_NAME, transferName);
            transferProps.put(PROP_TRANSFER_ACCESSION_INDICATOR, isAccession);
            DispositionAction da = this.dispositionService.getNextDispositionAction(nodeRef);
            if (da != null && (actionDef = da.getDispositionActionDefinition()) != null) {
                transferProps.put(PROP_TRANSFER_LOCATION, actionDef.getLocation());
            }
            NodeRef transferContainer = this.filePlanService.getTransferContainer(root);
            this.transferContainerType.disable();
            this.transferType.disable();
            try {
                transferNodeRef = this.nodeService.createNode(transferContainer, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)transferName), TYPE_TRANSFER, transferProps).getChildRef();
            }
            finally {
                this.transferContainerType.enable();
                this.transferType.enable();
            }
            AlfrescoTransactionSupport.bindResource((Object)KEY_TRANSFER_NODEREF, (Object)transferNodeRef);
        } else {
            List transferredAlready = this.nodeService.getChildAssocs(transferNodeRef, (QNamePattern)ASSOC_TRANSFERRED, (QNamePattern)ASSOC_TRANSFERRED);
            for (ChildAssociationRef car : transferredAlready) {
                if (!car.getChildRef().equals((Object)nodeRef)) continue;
                throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NODE_ALREADY_TRANSFER, (Object[])new Object[]{nodeRef.toString()}));
            }
        }
        this.transferType.disable();
        try {
            this.nodeService.addChild(transferNodeRef, nodeRef, ASSOC_TRANSFERRED, ASSOC_TRANSFERRED);
            this.setPDFIndicationFlag(transferNodeRef, nodeRef);
        }
        finally {
            this.transferType.enable();
        }
        this.nodeService.addAspect(nodeRef, ASPECT_TRANSFERRING, null);
        if (this.isRecordFolder(nodeRef)) {
            for (NodeRef record : this.recordService.getRecords(nodeRef)) {
                this.nodeService.addAspect(record, ASPECT_TRANSFERRING, null);
            }
        }
        return transferNodeRef;
    }

    private void setPDFIndicationFlag(NodeRef transferNodeRef, NodeRef dispositionLifeCycleNodeRef) {
        if (this.recordFolderService.isRecordFolder(dispositionLifeCycleNodeRef)) {
            List<NodeRef> records = this.recordService.getRecords(dispositionLifeCycleNodeRef);
            for (NodeRef record : records) {
                this.setPDFIndicationFlag(transferNodeRef, record);
            }
        } else {
            ContentData contentData = (ContentData)this.nodeService.getProperty(dispositionLifeCycleNodeRef, ContentModel.PROP_CONTENT);
            if (contentData != null && "application/pdf".equals(contentData.getMimetype())) {
                this.nodeService.setProperty(transferNodeRef, PROP_TRANSFER_PDF_INDICATOR, (Serializable)Boolean.valueOf(true));
            }
        }
    }

    @Override
    public void completeTransfer(NodeRef nodeRef) {
        boolean accessionIndicator = (Boolean)this.nodeService.getProperty(nodeRef, PROP_TRANSFER_ACCESSION_INDICATOR);
        String transferLocation = this.nodeService.getProperty(nodeRef, PROP_TRANSFER_LOCATION).toString();
        List assocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            if (this.freezeService.isFrozen(assoc.getChildRef())) {
                throw new AlfrescoRuntimeException("Could not complete a transfer that contains held folders");
            }
            if (this.freezeService.hasFrozenChildren(assoc.getChildRef())) {
                throw new AlfrescoRuntimeException("Cound not complete a transfer that contains folders with held children");
            }
            this.markComplete(assoc.getChildRef(), accessionIndicator, transferLocation);
        }
        this.nodeService.deleteNode(nodeRef);
        NodeRef transferNodeRef = (NodeRef)AlfrescoTransactionSupport.getResource((Object)KEY_TRANSFER_NODEREF);
        if (transferNodeRef != null && transferNodeRef.equals((Object)nodeRef)) {
            AlfrescoTransactionSupport.bindResource((Object)KEY_TRANSFER_NODEREF, null);
        }
    }

    private void markComplete(NodeRef nodeRef, boolean accessionIndicator, String transferLocation) {
        DispositionAction da = this.dispositionService.getNextDispositionAction(nodeRef);
        if (da != null) {
            this.nodeService.setProperty(da.getNodeRef(), PROP_DISPOSITION_ACTION_COMPLETED_AT, (Serializable)new Date());
            this.nodeService.setProperty(da.getNodeRef(), PROP_DISPOSITION_ACTION_COMPLETED_BY, (Serializable)((Object)AuthenticationUtil.getRunAsUser()));
        }
        this.nodeService.removeAspect(nodeRef, ASPECT_TRANSFERRING);
        this.nodeService.setProperty(nodeRef, PROP_LOCATION, (Serializable)((Object)transferLocation));
        QName markerAspectQName = null;
        markerAspectQName = accessionIndicator ? ASPECT_ASCENDED : ASPECT_TRANSFERRED;
        this.nodeService.addAspect(nodeRef, markerAspectQName, null);
        if (this.recordFolderService.isRecordFolder(nodeRef)) {
            List<NodeRef> records = this.recordService.getRecords(nodeRef);
            for (NodeRef record : records) {
                this.nodeService.addAspect(record, markerAspectQName, null);
                this.nodeService.setProperty(record, PROP_LOCATION, (Serializable)((Object)transferLocation));
            }
        }
        this.dispositionService.updateNextDispositionAction(nodeRef);
    }
}

