/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability;

import java.util.Arrays;
import java.util.List;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import org.alfresco.module.org_alfresco_module_rm.capability.RMAfterInvocationProvider;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.SearchParameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RMAfterInvocationProviderUnitTest {
    private static final NodeRef NODE_A = new NodeRef("test://node/a");
    @InjectMocks
    private RMAfterInvocationProvider rmAfterInvocationProvider;
    @Mock
    private Authentication authentication;
    @Mock
    Object object;
    @Mock
    ConfigAttributeDefinition config;
    @Mock
    AuthenticationUtil authenticationUtil;
    @Mock
    NodeService nodeService;
    @Mock
    ChildAssociationRef childAssocRefA;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.nodeService.exists(NODE_A)).thenReturn((Object)true);
        Mockito.when((Object)this.childAssocRefA.getParentRef()).thenReturn((Object)NODE_A);
        ConfigAttribute configAttribute = (ConfigAttribute)Mockito.mock(ConfigAttribute.class);
        Mockito.when((Object)configAttribute.getAttribute()).thenReturn((Object)"AFTER_RM.test");
        List<ConfigAttribute> configAttributes = Arrays.asList(configAttribute);
        Mockito.when((Object)this.config.getConfigAttributes()).thenReturn(configAttributes.iterator());
    }

    @Test
    public void testDecide_resultSet_unlimited() {
        ResultSet returnedObject = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)returnedObject.getResultSetMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)returnedObject.length()).thenReturn((Object)1);
        Mockito.when((Object)returnedObject.getNumberFound()).thenReturn((Object)1L);
        Mockito.when((Object)returnedObject.getNodeRef(0)).thenReturn((Object)NODE_A);
        Mockito.when((Object)returnedObject.getChildAssocRef(0)).thenReturn((Object)this.childAssocRefA);
        SearchParameters searchParameters = (SearchParameters)Mockito.mock(SearchParameters.class);
        Mockito.when((Object)searchParameters.getMaxItems()).thenReturn((Object)1);
        Mockito.when((Object)searchParameters.getSkipCount()).thenReturn((Object)0);
        Mockito.when((Object)searchParameters.getLanguage()).thenReturn((Object)"afts");
        Mockito.when((Object)resultSetMetaData.getSearchParameters()).thenReturn((Object)searchParameters);
        FilteringResultSet filteringResultSet = (FilteringResultSet)this.rmAfterInvocationProvider.decide(this.authentication, this.object, this.config, (Object)returnedObject);
        Assert.assertEquals((String)"Expected total of one result.", (long)1L, (long)filteringResultSet.getNumberFound());
        Assert.assertEquals((String)"Expected one result returned.", (long)1L, (long)filteringResultSet.length());
        Assert.assertEquals((String)"Expected that results were not limited by the page size.", (Object)LimitBy.UNLIMITED, (Object)filteringResultSet.getResultSetMetaData().getLimitedBy());
    }

    @Test
    public void testDecide_resultSet_skipped() {
        ResultSet returnedObject = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)returnedObject.getResultSetMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)returnedObject.length()).thenReturn((Object)0);
        Mockito.when((Object)returnedObject.getNumberFound()).thenReturn((Object)1L);
        SearchParameters searchParameters = (SearchParameters)Mockito.mock(SearchParameters.class);
        Mockito.when((Object)searchParameters.getMaxItems()).thenReturn((Object)1);
        Mockito.when((Object)searchParameters.getSkipCount()).thenReturn((Object)1);
        Mockito.when((Object)searchParameters.getLanguage()).thenReturn((Object)"afts");
        Mockito.when((Object)resultSetMetaData.getSearchParameters()).thenReturn((Object)searchParameters);
        FilteringResultSet filteringResultSet = (FilteringResultSet)this.rmAfterInvocationProvider.decide(this.authentication, this.object, this.config, (Object)returnedObject);
        Assert.assertEquals((String)"Expected total of one result.", (long)1L, (long)filteringResultSet.getNumberFound());
        Assert.assertEquals((String)"Expected no results returned.", (long)0L, (long)filteringResultSet.length());
        Assert.assertEquals((String)"Expected that results were not limited by the page size.", (Object)LimitBy.UNLIMITED, (Object)filteringResultSet.getResultSetMetaData().getLimitedBy());
    }

    @Test
    public void testDecide_resultSet_pageSize() {
        ResultSet returnedObject = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)returnedObject.getResultSetMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)returnedObject.length()).thenReturn((Object)1);
        Mockito.when((Object)returnedObject.getNumberFound()).thenReturn((Object)1L);
        Mockito.when((Object)returnedObject.getNodeRef(0)).thenReturn((Object)NODE_A);
        Mockito.when((Object)returnedObject.getChildAssocRef(0)).thenReturn((Object)this.childAssocRefA);
        SearchParameters searchParameters = (SearchParameters)Mockito.mock(SearchParameters.class);
        Mockito.when((Object)searchParameters.getMaxItems()).thenReturn((Object)0);
        Mockito.when((Object)searchParameters.getSkipCount()).thenReturn((Object)0);
        Mockito.when((Object)searchParameters.getLanguage()).thenReturn((Object)"afts");
        Mockito.when((Object)resultSetMetaData.getSearchParameters()).thenReturn((Object)searchParameters);
        FilteringResultSet filteringResultSet = (FilteringResultSet)this.rmAfterInvocationProvider.decide(this.authentication, this.object, this.config, (Object)returnedObject);
        Assert.assertEquals((String)"Expected total of one result.", (long)1L, (long)filteringResultSet.getNumberFound());
        Assert.assertEquals((String)"Expected no results returned.", (long)0L, (long)filteringResultSet.length());
        Assert.assertEquals((String)"Expected that results were limited by page size.", (Object)LimitBy.FINAL_SIZE, (Object)filteringResultSet.getResultSetMetaData().getLimitedBy());
    }
}

