/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util.bdt;

import org.alfresco.module.org_alfresco_module_rm.test.util.bdt.ExpectedFailure;
import org.alfresco.module.org_alfresco_module_rm.test.util.bdt.ExpectedValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;

public class BehaviourTest {
    private static RetryingTransactionHelper retryingTransactionHelper;
    private String asUser = AuthenticationUtil.getAdminUserName();

    public static void initBehaviourTests(RetryingTransactionHelper retryingTransactionHelper) {
        BehaviourTest.retryingTransactionHelper = retryingTransactionHelper;
    }

    public static BehaviourTest test() {
        return new BehaviourTest();
    }

    RetryingTransactionHelper getRetryingTransactionHelper() {
        return retryingTransactionHelper;
    }

    String getAsUser() {
        return this.asUser;
    }

    public BehaviourTest asAdmin() {
        return this.as(AuthenticationUtil.getAdminUserName());
    }

    public BehaviourTest as(String asUser) {
        this.asUser = asUser;
        return this;
    }

    public BehaviourTest given() {
        return this;
    }

    public BehaviourTest given(Work given) {
        return this.perform(given);
    }

    public BehaviourTest when() {
        return this;
    }

    public BehaviourTest when(Work when) {
        return this.perform(when);
    }

    public BehaviourTest then() {
        return this;
    }

    public BehaviourTest then(Work then) {
        return this.perform(then);
    }

    public ExpectedValue<Boolean> expect(boolean value) {
        return new ExpectedValue<Boolean>(this, value);
    }

    public ExpectedValue<String> expect(String value) {
        return new ExpectedValue<String>(this, value);
    }

    public ExpectedValue<Object> expect(Object value) {
        return new ExpectedValue<Object>(this, value);
    }

    public ExpectedFailure expectException(Class<? extends Exception> exceptionClass) {
        return new ExpectedFailure(this, exceptionClass);
    }

    public BehaviourTest perform(int count, Work work) {
        for (int i = 0; i < count; ++i) {
            this.perform(work);
        }
        return this;
    }

    public BehaviourTest perform(Work work) {
        return (BehaviourTest)AuthenticationUtil.runAs(() -> (BehaviourTest)retryingTransactionHelper.doInTransaction(() -> {
            work.doIt();
            return this;
        }), (String)this.asUser);
    }

    public static interface Work {
        public void doIt() throws Exception;
    }
}

