/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.admin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.repo.dictionary.DictionaryRepositoryBootstrap;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class RecordsManagementAdminBase
implements RecordsManagementCustomModel {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static final String SOURCE_TARGET_ID_SEPARATOR = "__";
    private static final NodeRef RM_CUSTOM_MODEL_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "records_management_custom_model");
    private static final String MSG_CUSTOM_MODEL_NOT_FOUND = "rm.admin.custom-model-not-found";
    private static final String MSG_CUSTOM_MODEL_NO_CONTENT = "rm.admin.custom-model-no-content";
    private static final String MSG_ERROR_WRITE_CUSTOM_MODEL = "rm.admin.error-write-custom-model";
    private static final String MSG_ERROR_SPLIT_ID = "rm.admin.error-split-id";
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private ContentService contentService;
    private NamespaceService namespaceService;
    private DictionaryRepositoryBootstrap dictionaryRepositoryBootstrap;

    protected DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    protected ContentService getContentService() {
        return this.contentService;
    }

    protected NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    protected DictionaryRepositoryBootstrap getDictionaryRepositoryBootstrap() {
        return this.dictionaryRepositoryBootstrap;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryRepositoryBootstrap(DictionaryRepositoryBootstrap dictionaryRepositoryBootstrap) {
        this.dictionaryRepositoryBootstrap = dictionaryRepositoryBootstrap;
    }

    protected Map<QName, AssociationDefinition> getCustomAssociations() {
        HashMap<QName, AssociationDefinition> customAssociations = new HashMap<QName, AssociationDefinition>();
        AspectDefinition aspectDefn = this.getDictionaryService().getAspect(ASPECT_CUSTOM_ASSOCIATIONS);
        if (aspectDefn != null) {
            customAssociations.putAll(aspectDefn.getAssociations());
        }
        return customAssociations;
    }

    protected NodeRef getCustomModelRef(String uri) {
        if (uri.equals("") || uri.equals("http://www.alfresco.org/model/rmcustom/1.0")) {
            return RM_CUSTOM_MODEL_NODE_REF;
        }
        List modelRefs = this.getDictionaryRepositoryBootstrap().getModelRefs();
        for (NodeRef modelRef : modelRefs) {
            try {
                M2Model model = this.readCustomContentModel(modelRef);
                for (M2Namespace namespace : model.getNamespaces()) {
                    if (!namespace.getUri().equals(uri)) continue;
                    return modelRef;
                }
            }
            catch (DictionaryException de) {
                this.logger.warn((Object)("readCustomContentModel: skip model (" + String.valueOf(modelRef) + ") whilst searching for uri (" + uri + "): "), (Throwable)de);
            }
        }
        throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CUSTOM_MODEL_NOT_FOUND, (Object[])new Object[]{uri}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected M2Model readCustomContentModel(NodeRef modelNodeRef) {
        ContentReader reader = this.getContentService().getReader(modelNodeRef, ContentModel.TYPE_CONTENT);
        if (!reader.exists()) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CUSTOM_MODEL_NO_CONTENT, (Object[])new Object[]{modelNodeRef.toString()}));
        }
        InputStream contentIn = null;
        M2Model deserializedModel = null;
        try {
            contentIn = reader.getContentInputStream();
            deserializedModel = M2Model.createModel((InputStream)contentIn);
        }
        finally {
            try {
                if (contentIn != null) {
                    contentIn.close();
                }
            }
            catch (IOException iOException) {}
        }
        return deserializedModel;
    }

    protected void writeCustomContentModel(NodeRef modelRef, M2Model deserializedModel) {
        ContentWriter writer = this.getContentService().getWriter(modelRef, ContentModel.TYPE_CONTENT, true);
        writer.setMimetype("text/xml");
        writer.setEncoding("UTF-8");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        deserializedModel.toXML((OutputStream)baos);
        try {
            String updatedModelXml = baos.toString("UTF-8");
            writer.putContent(updatedModelXml);
        }
        catch (UnsupportedEncodingException uex) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_ERROR_WRITE_CUSTOM_MODEL, (Object[])new Object[]{modelRef.toString()}), (Throwable)uex);
        }
    }

    protected boolean existsTitle(String associationDefinitionTitle) {
        boolean existsLabel = false;
        Collection<AssociationDefinition> associationDefinitions = this.getCustomAssociations().values();
        for (AssociationDefinition associationDefinition : associationDefinitions) {
            if (!associationDefinition.getTitle((MessageLookup)this.getDictionaryService()).equalsIgnoreCase(associationDefinitionTitle)) continue;
            existsLabel = true;
        }
        return existsLabel;
    }

    protected String[] splitAssociationDefinitionTitle(String sourceTargetText) {
        if (!sourceTargetText.contains(SOURCE_TARGET_ID_SEPARATOR)) {
            throw new IllegalArgumentException(I18NUtil.getMessage((String)MSG_ERROR_SPLIT_ID, (Object[])new Object[]{sourceTargetText, SOURCE_TARGET_ID_SEPARATOR}));
        }
        return sourceTargetText.split(SOURCE_TARGET_ID_SEPARATOR);
    }

    protected String composeAssociationDefinitionTitle(String sourceText, String targetText) {
        if (sourceText.contains(SOURCE_TARGET_ID_SEPARATOR)) {
            throw new IllegalArgumentException("sourceId cannot contain '__': " + sourceText);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sourceText).append(SOURCE_TARGET_ID_SEPARATOR).append(targetText);
        return sb.toString();
    }
}

