/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.bulk;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkMonitor;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkOperation;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkProgress;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkStatusUpdater;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.rest.api.search.impl.SearchMapper;
import org.alfresco.rest.api.search.model.Query;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;

public abstract class BulkBaseService<T>
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(BulkBaseService.class);
    protected ExecutorService executorService;
    protected ServiceRegistry serviceRegistry;
    protected SearchService searchService;
    protected TransactionService transactionService;
    protected SearchMapper searchMapper;
    protected BulkMonitor<T> bulkMonitor;
    protected int threadCount;
    protected int batchSize;
    protected int itemsPerTransaction;
    protected int maxItems;
    protected int loggingInterval;
    protected int maxParallelRequests;

    public void afterPropertiesSet() throws Exception {
        this.searchService = this.serviceRegistry.getSearchService();
        this.executorService = Executors.newFixedThreadPool(this.maxParallelRequests);
    }

    public T execute(NodeRef nodeRef, BulkOperation bulkOperation) {
        this.checkPermissions(nodeRef, bulkOperation);
        ResultSet resultSet = this.getTotalItems(bulkOperation.searchQuery(), this.maxItems);
        if ((long)this.maxItems < resultSet.getNumberFound() || resultSet.hasMore()) {
            throw new InvalidArgumentException("Too many items to process. Please refine your query.");
        }
        long totalItems = resultSet.getNumberFound();
        String processId = UUID.randomUUID().toString();
        T initBulkStatus = this.getInitBulkStatus(processId, totalItems);
        this.bulkMonitor.updateBulkStatus(initBulkStatus);
        this.bulkMonitor.registerProcess(nodeRef, processId, bulkOperation);
        BulkProgress bulkProgress = new BulkProgress(totalItems, processId, new AtomicBoolean(false), new AtomicInteger(0));
        BatchProcessor.BatchProcessWorker<NodeRef> batchProcessWorker = this.getWorkerProvider(nodeRef, bulkOperation, bulkProgress);
        BulkStatusUpdater bulkStatusUpdater = this.getBulkStatusUpdater();
        BatchProcessor batchProcessor = new BatchProcessor(processId, this.transactionService.getRetryingTransactionHelper(), this.getWorkProvider(bulkOperation, bulkStatusUpdater, bulkProgress), this.threadCount, this.itemsPerTransaction, (ApplicationEventPublisher)bulkStatusUpdater, LOG, this.loggingInterval);
        this.runAsyncBatchProcessor((BatchProcessor<NodeRef>)batchProcessor, batchProcessWorker, bulkStatusUpdater);
        return initBulkStatus;
    }

    protected void runAsyncBatchProcessor(BatchProcessor<NodeRef> batchProcessor, BatchProcessor.BatchProcessWorker<NodeRef> batchProcessWorker, BulkStatusUpdater bulkStatusUpdater) {
        Runnable backgroundLogic = () -> {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Started processing batch with name: " + batchProcessor.getProcessName()));
                }
                batchProcessor.processLong(batchProcessWorker, true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Processing batch with name: " + batchProcessor.getProcessName() + " completed"));
                }
            }
            catch (Exception exception) {
                LOG.error((Object)("Error processing batch with name: " + batchProcessor.getProcessName()), (Throwable)exception);
            }
            finally {
                bulkStatusUpdater.update();
            }
        };
        this.executorService.submit(backgroundLogic);
    }

    protected abstract T getInitBulkStatus(String var1, long var2);

    protected abstract BulkStatusUpdater getBulkStatusUpdater();

    protected abstract BatchProcessWorkProvider<NodeRef> getWorkProvider(BulkOperation var1, BulkStatusUpdater var2, BulkProgress var3);

    protected abstract BatchProcessor.BatchProcessWorker<NodeRef> getWorkerProvider(NodeRef var1, BulkOperation var2, BulkProgress var3);

    protected abstract void checkPermissions(NodeRef var1, BulkOperation var2);

    protected ResultSet getTotalItems(Query searchQuery, int skipCount) {
        SearchParameters searchParams = new SearchParameters();
        this.searchMapper.setDefaults(searchParams);
        this.searchMapper.fromQuery(searchParams, searchQuery);
        searchParams.setSkipCount(skipCount);
        searchParams.setMaxItems(1);
        searchParams.setLimit(1);
        return this.searchService.query(searchParams);
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setSearchMapper(SearchMapper searchMapper) {
        this.searchMapper = searchMapper;
    }

    public void setBulkMonitor(BulkMonitor<T> bulkMonitor) {
        this.bulkMonitor = bulkMonitor;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void setLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public void setItemsPerTransaction(int itemsPerTransaction) {
        this.itemsPerTransaction = itemsPerTransaction;
    }

    public void setMaxParallelRequests(int maxParallelRequests) {
        this.maxParallelRequests = maxParallelRequests;
    }
}

