/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.RecordsManagementContainerType;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.module.org_alfresco_module_rm.test.util.TestModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RecordsManagementContainerTypeUnitTest
extends BaseUnitTest {
    @InjectMocks
    private RecordsManagementContainerType recordManagementContainerType;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(ContentModel.TYPE_FOLDER, ContentModel.TYPE_FOLDER)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(ContentModel.TYPE_FOLDER, ContentModel.TYPE_SYSTEM_FOLDER)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TestModel.NOT_RM_FOLDER_TYPE, ContentModel.TYPE_FOLDER)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TestModel.NOT_RM_FOLDER_TYPE, ContentModel.TYPE_SYSTEM_FOLDER)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TYPE_RECORD_CATEGORY, ContentModel.TYPE_FOLDER)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(TYPE_RECORD_CATEGORY, ContentModel.TYPE_SYSTEM_FOLDER)).thenReturn((Object)false);
    }

    @Test
    public void testAddNonRMFolderSubtypeToRMContainer() {
        NodeRef rmContainer = this.generateRMContainer();
        NodeRef folder = this.generateNonRmFolderSubtypeNode();
        ChildAssociationRef childAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, rmContainer, ContentModel.ASSOC_CONTAINS, folder);
        this.recordManagementContainerType.onCreateChildAssociation(childAssoc, true);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).setType((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any());
    }

    @Test
    public void testAddFolderInFilePlan() {
        NodeRef fileplan = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getType(fileplan)).thenReturn((Object)TYPE_FILE_PLAN);
        NodeRef folder = this.generateNonRmFolderNode();
        ChildAssociationRef childAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, fileplan, ContentModel.ASSOC_CONTAINS, folder);
        this.recordManagementContainerType.onCreateChildAssociation(childAssoc, true);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setType(folder, TYPE_RECORD_CATEGORY);
    }

    @Test
    public void testAddFolderInRecordCategory() {
        NodeRef category = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getType(category)).thenReturn((Object)TYPE_RECORD_CATEGORY);
        NodeRef folder = this.generateNonRmFolderNode();
        ChildAssociationRef childAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, category, ContentModel.ASSOC_CONTAINS, folder);
        this.recordManagementContainerType.onCreateChildAssociation(childAssoc, true);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setType(folder, TYPE_RECORD_FOLDER);
    }

    @Test
    public void testAddFolderInUnfiledRecordContainer() {
        NodeRef unfiledRecordContainer = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getType(unfiledRecordContainer)).thenReturn((Object)TYPE_UNFILED_RECORD_CONTAINER);
        NodeRef folder = this.generateNonRmFolderNode();
        ChildAssociationRef childAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, unfiledRecordContainer, ContentModel.ASSOC_CONTAINS, folder);
        this.recordManagementContainerType.onCreateChildAssociation(childAssoc, true);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setType(folder, TYPE_UNFILED_RECORD_FOLDER);
    }

    @Test
    public void testAddFolderInUnfiledRecordFolder() {
        NodeRef unfiledRecordFolder = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getType(unfiledRecordFolder)).thenReturn((Object)TYPE_UNFILED_RECORD_FOLDER);
        NodeRef folder = this.generateNonRmFolderNode();
        ChildAssociationRef childAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, unfiledRecordFolder, ContentModel.ASSOC_CONTAINS, folder);
        this.recordManagementContainerType.onCreateChildAssociation(childAssoc, true);
        ((NodeService)Mockito.verify((Object)this.mockedNodeService)).setType(folder, TYPE_UNFILED_RECORD_FOLDER);
    }

    private NodeRef generateRMContainer() {
        NodeRef rmContainer = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getType(rmContainer)).thenReturn((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER);
        return rmContainer;
    }

    private NodeRef generateNonRmFolderSubtypeNode() {
        NodeRef nonRmFolder = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getType(nonRmFolder)).thenReturn((Object)TestModel.NOT_RM_FOLDER_TYPE);
        Mockito.when((Object)this.mockedNodeService.exists(nonRmFolder)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(nonRmFolder, ASPECT_FILE_PLAN_COMPONENT)).thenReturn((Object)false);
        return nonRmFolder;
    }

    private NodeRef generateNonRmFolderNode() {
        NodeRef regularFolder = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getType(regularFolder)).thenReturn((Object)ContentModel.TYPE_FOLDER);
        Mockito.when((Object)this.mockedNodeService.exists(regularFolder)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(regularFolder, ASPECT_FILE_PLAN_COMPONENT)).thenReturn((Object)false);
        return regularFolder;
    }
}

