/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseWebScriptUnitTest;
import org.alfresco.repo.action.ActionDefinitionImpl;
import org.alfresco.repo.web.scripts.rule.RmActionDefinitionsGet;
import org.alfresco.repo.web.scripts.rule.WhitelistedDMActions;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.extensions.webscripts.AbstractWebScript;

public class RmActionDefinitionsGetUnitTest
extends BaseWebScriptUnitTest {
    @Mock
    private RecordsManagementActionService mockedRecordsManagementActionService;
    @Mock
    private ActionService mockedExtendedActionService;
    @InjectMocks
    private RmActionDefinitionsGet webScript;
    private List<String> whitelistedActions = WhitelistedDMActions.getActionsList();

    @Override
    protected AbstractWebScript getWebScript() {
        return this.webScript;
    }

    @Override
    protected String getWebScriptTemplate() {
        return "alfresco/templates/webscripts/org/alfresco/repository/rule/rm-actiondefinitions.get.json.ftl";
    }

    @Override
    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        this.webScript.setRecordsManagementActionService(this.mockedRecordsManagementActionService);
        this.webScript.setExtendedActionService(this.mockedExtendedActionService);
    }

    @Test
    public void getRmActionDefinitionsWithWhitelistedDMActions() throws Exception {
        ArrayList<ActionDefinitionImpl> dmActionDefinitions = new ArrayList<ActionDefinitionImpl>();
        for (String action : this.whitelistedActions) {
            dmActionDefinitions.add(new ActionDefinitionImpl(action));
        }
        Mockito.when((Object)this.mockedRecordsManagementActionService.getRecordsManagementActions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockedExtendedActionService.getActionDefinitions()).thenReturn(dmActionDefinitions);
        String jsonResponse = this.executeWebScript(Collections.emptyMap());
        Assert.assertNotNull((Object)jsonResponse);
        ObjectMapper mapper = new ObjectMapper();
        Map responseMap = (Map)mapper.readValue(jsonResponse, Map.class);
        ArrayList actionDefinitions = (ArrayList)responseMap.get("data");
        Assert.assertEquals((long)WhitelistedDMActions.getActionsList().size(), (long)actionDefinitions.size());
        for (LinkedHashMap actionDefinition : actionDefinitions) {
            Assert.assertTrue((boolean)this.whitelistedActions.contains(actionDefinition.get("name")));
        }
    }

    @Test
    public void getRmActionDefinitionsWithNonWhitelistedDMActions() throws Exception {
        String dmAction = "notWhitelisted";
        List<ActionDefinition> dmActionDefinitions = Arrays.asList(new ActionDefinitionImpl(dmAction));
        Mockito.when((Object)this.mockedRecordsManagementActionService.getRecordsManagementActions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockedExtendedActionService.getActionDefinitions()).thenReturn(dmActionDefinitions);
        String jsonResponse = this.executeWebScript(Collections.emptyMap());
        Assert.assertNotNull((Object)jsonResponse);
        ObjectMapper mapper = new ObjectMapper();
        Map responseMap = (Map)mapper.readValue(jsonResponse, Map.class);
        ArrayList actionDefinitions = (ArrayList)responseMap.get("data");
        Assert.assertFalse((boolean)actionDefinitions.contains(dmAction));
    }
}

