/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.transfers;

import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.Transfer;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="transfers", title="Transfers")
public class TransferEntityResource
implements EntityResourceAction.ReadById<Transfer>,
InitializingBean {
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"apiNodesModelFactory", (Object)this.nodesModelFactory);
    }

    @WebApiDescription(title="Get transfer information", description="Gets information for a transfer with id 'transferId'")
    @WebApiParam(name="transferId", title="The transfer id")
    public Transfer readById(String transferId, Parameters parameters) throws EntityNotFoundException {
        RMParameterCheck.checkNotBlank("transferId", transferId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(transferId, RecordsManagementModel.TYPE_TRANSFER);
        FileInfo info = this.fileFolderService.getFileInfo(nodeRef);
        return this.nodesModelFactory.createTransfer(info, parameters, null, false);
    }
}

