/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class FilePlanServiceImplTest
extends BaseRMTestCase {
    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testIsFilePlan() {
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertTrue((boolean)FilePlanServiceImplTest.this.filePlanService.isFilePlan(FilePlanServiceImplTest.this.filePlan));
                TestCase.assertFalse((boolean)FilePlanServiceImplTest.this.filePlanService.isFilePlan(FilePlanServiceImplTest.this.rmContainer));
                TestCase.assertFalse((boolean)FilePlanServiceImplTest.this.filePlanService.isFilePlan(FilePlanServiceImplTest.this.dmDocument));
            }
        });
    }

    public void testGetFilePlans() {
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertEquals((Object)FilePlanServiceImplTest.this.filePlan, (Object)FilePlanServiceImplTest.this.filePlanService.getFilePlan(FilePlanServiceImplTest.this.filePlan));
                TestCase.assertEquals((Object)FilePlanServiceImplTest.this.filePlan, (Object)FilePlanServiceImplTest.this.filePlanService.getFilePlan(FilePlanServiceImplTest.this.rmContainer));
                TestCase.assertEquals((Object)FilePlanServiceImplTest.this.filePlan, (Object)FilePlanServiceImplTest.this.filePlanService.getFilePlan(FilePlanServiceImplTest.this.rmFolder));
                TestCase.assertNull((Object)FilePlanServiceImplTest.this.filePlanService.getFilePlan(FilePlanServiceImplTest.this.dmDocument));
            }
        });
    }

    public void testGetFilePlanBySiteId() {
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertEquals((Object)FilePlanServiceImplTest.this.filePlan, (Object)FilePlanServiceImplTest.this.filePlanService.getFilePlanBySiteId(FilePlanServiceImplTest.this.siteId));
                TestCase.assertNull((Object)FilePlanServiceImplTest.this.filePlanService.getFilePlanBySiteId("rubbish"));
                String siteId = GUID.generate();
                FilePlanServiceImplTest.this.siteService.createSite("anything", siteId, "title", "descrition", SiteVisibility.PUBLIC);
                TestCase.assertNull((Object)FilePlanServiceImplTest.this.filePlanService.getFilePlanBySiteId(siteId));
            }
        });
    }

    public void testIsFilePlanComponent() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                TestCase.assertTrue((String)"The rm root container should be a rm component", (boolean)FilePlanServiceImplTest.this.filePlanService.isFilePlanComponent(FilePlanServiceImplTest.this.filePlan));
                TestCase.assertTrue((String)"The rm container should be a rm component", (boolean)FilePlanServiceImplTest.this.filePlanService.isFilePlanComponent(FilePlanServiceImplTest.this.rmContainer));
                TestCase.assertTrue((String)"The rm folder should be a rm component", (boolean)FilePlanServiceImplTest.this.filePlanService.isFilePlanComponent(FilePlanServiceImplTest.this.rmFolder));
                return null;
            }
        });
    }

    public void testGetFilePlanComponentKind() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                return FilePlanServiceImplTest.this.utils.createRecord(FilePlanServiceImplTest.this.rmFolder, "testRecord.txt");
            }

            public void test(NodeRef result) throws Exception {
                TestCase.assertEquals((Object)FilePlanComponentKind.FILE_PLAN, (Object)FilePlanServiceImplTest.this.filePlanService.getFilePlanComponentKind(FilePlanServiceImplTest.this.filePlan));
                TestCase.assertEquals((Object)FilePlanComponentKind.RECORD_CATEGORY, (Object)FilePlanServiceImplTest.this.filePlanService.getFilePlanComponentKind(FilePlanServiceImplTest.this.rmContainer));
                TestCase.assertEquals((Object)FilePlanComponentKind.RECORD_FOLDER, (Object)FilePlanServiceImplTest.this.filePlanService.getFilePlanComponentKind(FilePlanServiceImplTest.this.rmFolder));
                TestCase.assertEquals((Object)FilePlanComponentKind.RECORD, (Object)FilePlanServiceImplTest.this.filePlanService.getFilePlanComponentKind(result));
                TestCase.assertNull((Object)FilePlanServiceImplTest.this.filePlanService.getFilePlanComponentKind(FilePlanServiceImplTest.this.folder));
            }
        });
    }

    public void testIsRecordCategory() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                TestCase.assertFalse((String)"This should not be a record category.", (boolean)FilePlanServiceImplTest.this.filePlanService.isRecordCategory(FilePlanServiceImplTest.this.filePlan));
                TestCase.assertTrue((String)"This is a record category.", (boolean)FilePlanServiceImplTest.this.filePlanService.isRecordCategory(FilePlanServiceImplTest.this.rmContainer));
                TestCase.assertFalse((String)"This should not be a record category.", (boolean)FilePlanServiceImplTest.this.filePlanService.isRecordCategory(FilePlanServiceImplTest.this.rmFolder));
                return null;
            }
        });
    }

    public void testCreateFilePlan() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                String id = this.setString("id", GUID.generate());
                return FilePlanServiceImplTest.this.filePlanService.createFilePlan(FilePlanServiceImplTest.this.folder, id);
            }

            public void test(NodeRef result) {
                TestCase.assertNotNull((String)"Unable to create records management root", (Object)result);
                FilePlanServiceImplTest.this.basicRMContainerCheck(result, this.getString("id"), RecordsManagementModel.TYPE_FILE_PLAN);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                String id = this.setString("id", GUID.generate());
                return FilePlanServiceImplTest.this.filePlanService.createFilePlan(FilePlanServiceImplTest.this.folder, id, RecordsManagementModel.TYPE_FILE_PLAN);
            }

            public void test(NodeRef result) {
                TestCase.assertNotNull((String)"Unable to create records management root", (Object)result);
                FilePlanServiceImplTest.this.basicRMContainerCheck(result, this.getString("id"), RecordsManagementModel.TYPE_FILE_PLAN);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                FilePlanServiceImplTest.this.filePlanService.createFilePlan(FilePlanServiceImplTest.this.rmContainer, GUID.generate());
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                FilePlanServiceImplTest.this.filePlanService.createFilePlan(FilePlanServiceImplTest.this.folder, GUID.generate(), ContentModel.TYPE_FOLDER);
            }
        });
    }

    private void basicRMContainerCheck(NodeRef nodeRef, String name, QName type) {
        FilePlanServiceImplTest.assertEquals((Object)name, (Object)this.nodeService.getProperty(nodeRef, PROP_NAME));
        FilePlanServiceImplTest.assertNotNull((String)"RM id has not been set", (Object)this.nodeService.getProperty(nodeRef, PROP_IDENTIFIER));
        FilePlanServiceImplTest.assertEquals((Object)type, (Object)this.nodeService.getType(nodeRef));
    }

    public void testCreateRecordCategory() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                String id = this.setString("id", GUID.generate());
                return FilePlanServiceImplTest.this.filePlanService.createRecordCategory(FilePlanServiceImplTest.this.filePlan, id);
            }

            public void test(NodeRef result) {
                TestCase.assertNotNull((String)"Unable to create records management container", (Object)result);
                FilePlanServiceImplTest.this.basicRMContainerCheck(result, this.getString("id"), RecordsManagementModel.TYPE_RECORD_CATEGORY);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                String id = this.setString("id", GUID.generate());
                return FilePlanServiceImplTest.this.filePlanService.createRecordCategory(FilePlanServiceImplTest.this.rmContainer, id);
            }

            public void test(NodeRef result) {
                TestCase.assertNotNull((String)"Unable to create records management container", (Object)result);
                FilePlanServiceImplTest.this.basicRMContainerCheck(result, this.getString("id"), RecordsManagementModel.TYPE_RECORD_CATEGORY);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                FilePlanServiceImplTest.this.filePlanService.createRecordCategory(FilePlanServiceImplTest.this.folder, GUID.generate());
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                FilePlanServiceImplTest.this.filePlanService.createRecordCategory(FilePlanServiceImplTest.this.filePlan, GUID.generate(), ContentModel.TYPE_FOLDER);
            }
        });
    }

    public void testGetAllContained() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef series = FilePlanServiceImplTest.this.filePlanService.createRecordCategory(FilePlanServiceImplTest.this.rmContainer, "rmSeries");
                NodeRef seriesChildFolder = FilePlanServiceImplTest.this.recordFolderService.createRecordFolder(series, "seriesRecordFolder");
                NodeRef seriesChildContainer = FilePlanServiceImplTest.this.filePlanService.createRecordCategory(series, "childContainer");
                this.setNodeRef("series", series);
                this.setNodeRef("seriesChildFolder", seriesChildFolder);
                this.setNodeRef("seriesChildContainer", seriesChildContainer);
                return null;
            }

            public void test(Void result) throws Exception {
                List nodes = FilePlanServiceImplTest.this.filePlanService.getAllContained(FilePlanServiceImplTest.this.rmContainer);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)2, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                TestCase.assertTrue((boolean)nodes.contains(FilePlanServiceImplTest.this.rmFolder));
                nodes = FilePlanServiceImplTest.this.filePlanService.getAllContained(FilePlanServiceImplTest.this.rmContainer, false);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)2, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                TestCase.assertTrue((boolean)nodes.contains(FilePlanServiceImplTest.this.rmFolder));
                nodes = FilePlanServiceImplTest.this.filePlanService.getAllContained(FilePlanServiceImplTest.this.rmContainer, true);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)4, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                TestCase.assertTrue((boolean)nodes.contains(FilePlanServiceImplTest.this.rmFolder));
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("seriesChildFolder")));
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("seriesChildContainer")));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                FilePlanServiceImplTest.this.filePlanService.getAllContained(FilePlanServiceImplTest.this.rmFolder);
            }
        });
    }

    public void testGetContainedRecordCategories() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef series = FilePlanServiceImplTest.this.filePlanService.createRecordCategory(FilePlanServiceImplTest.this.rmContainer, "rmSeries");
                NodeRef seriesChildFolder = FilePlanServiceImplTest.this.recordFolderService.createRecordFolder(series, "seriesRecordFolder");
                NodeRef seriesChildContainer = FilePlanServiceImplTest.this.filePlanService.createRecordCategory(series, "childContainer");
                this.setNodeRef("series", series);
                this.setNodeRef("seriesChildFolder", seriesChildFolder);
                this.setNodeRef("seriesChildContainer", seriesChildContainer);
                return null;
            }

            public void test(Void result) throws Exception {
                List nodes = FilePlanServiceImplTest.this.filePlanService.getContainedRecordCategories(FilePlanServiceImplTest.this.rmContainer);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)1, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                nodes = FilePlanServiceImplTest.this.filePlanService.getContainedRecordCategories(FilePlanServiceImplTest.this.rmContainer, false);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)1, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                nodes = FilePlanServiceImplTest.this.filePlanService.getContainedRecordCategories(FilePlanServiceImplTest.this.rmContainer, true);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)2, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("series")));
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("seriesChildContainer")));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                FilePlanServiceImplTest.this.filePlanService.getContainedRecordCategories(FilePlanServiceImplTest.this.rmFolder);
            }
        });
    }

    public void testGetContainedRecordFolders() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef series = FilePlanServiceImplTest.this.filePlanService.createRecordCategory(FilePlanServiceImplTest.this.rmContainer, "rmSeries");
                NodeRef seriesChildFolder = FilePlanServiceImplTest.this.recordFolderService.createRecordFolder(series, "seriesRecordFolder");
                NodeRef seriesChildContainer = FilePlanServiceImplTest.this.filePlanService.createRecordCategory(series, "childContainer");
                this.setNodeRef("series", series);
                this.setNodeRef("seriesChildFolder", seriesChildFolder);
                this.setNodeRef("seriesChildContainer", seriesChildContainer);
                return null;
            }

            public void test(Void result) throws Exception {
                List nodes = FilePlanServiceImplTest.this.filePlanService.getContainedRecordFolders(FilePlanServiceImplTest.this.rmContainer);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)1, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(FilePlanServiceImplTest.this.rmFolder));
                nodes = FilePlanServiceImplTest.this.filePlanService.getContainedRecordFolders(FilePlanServiceImplTest.this.rmContainer, false);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)1, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(FilePlanServiceImplTest.this.rmFolder));
                nodes = FilePlanServiceImplTest.this.filePlanService.getContainedRecordFolders(FilePlanServiceImplTest.this.rmContainer, true);
                TestCase.assertNotNull((Object)nodes);
                TestCase.assertEquals((int)2, (int)nodes.size());
                TestCase.assertTrue((boolean)nodes.contains(FilePlanServiceImplTest.this.rmFolder));
                TestCase.assertTrue((boolean)nodes.contains(this.getNodeRef("seriesChildFolder")));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                FilePlanServiceImplTest.this.filePlanService.getContainedRecordFolders(FilePlanServiceImplTest.this.rmFolder);
            }
        });
    }

    public void testCreateSimpleHierarchy() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef levelOne = this.setNodeRef("container1", FilePlanServiceImplTest.this.filePlanService.createRecordCategory(FilePlanServiceImplTest.this.filePlan, "container1"));
                TestCase.assertNotNull((String)"Unable to create container", (Object)levelOne);
                NodeRef levelTwo = this.setNodeRef("container2", FilePlanServiceImplTest.this.filePlanService.createRecordCategory(levelOne, "container2"));
                TestCase.assertNotNull((String)"Unable to create container", (Object)levelTwo);
                NodeRef levelThree = this.setNodeRef("container3", FilePlanServiceImplTest.this.filePlanService.createRecordCategory(levelTwo, "container3"));
                TestCase.assertNotNull((String)"Unable to create container", (Object)levelThree);
                NodeRef levelThreeRecordFolder = this.setNodeRef("recordFolder3", FilePlanServiceImplTest.this.recordFolderService.createRecordFolder(levelThree, "recordFolder3"));
                TestCase.assertNotNull((String)"Unable to create record folder", (Object)levelThreeRecordFolder);
                return null;
            }

            public void test(Void result) {
                FilePlanServiceImplTest.this.basicRMContainerCheck(this.getNodeRef("container1"), "container1", RecordsManagementModel.TYPE_RECORD_CATEGORY);
                FilePlanServiceImplTest.this.basicRMContainerCheck(this.getNodeRef("container2"), "container2", RecordsManagementModel.TYPE_RECORD_CATEGORY);
                FilePlanServiceImplTest.this.basicRMContainerCheck(this.getNodeRef("container3"), "container3", RecordsManagementModel.TYPE_RECORD_CATEGORY);
                FilePlanServiceImplTest.this.basicRMContainerCheck(this.getNodeRef("recordFolder3"), "recordFolder3", RecordsManagementModel.TYPE_RECORD_FOLDER);
            }
        });
    }
}

