/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.bootstrap;

import org.alfresco.module.org_alfresco_module_rm.bootstrap.BootstrapImporterModuleComponent;
import org.alfresco.module.org_alfresco_module_rm.bootstrap.RecordContributorsGroupBootstrapComponent;
import org.alfresco.module.org_alfresco_module_rm.patch.ModulePatchExecuter;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BootstrapImporterModuleComponentUnitTest
extends BaseUnitTest {
    private static final NodeRef configNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rm_config_folder");
    @Mock(name="importer")
    private ImporterBootstrap mockedImporter;
    @Mock(name="modulePatchExecuter")
    private ModulePatchExecuter mockedModulePatchExecuter;
    @Mock(name="recordContributorsGroupBootstrapComponent")
    private RecordContributorsGroupBootstrapComponent mockedRecordContributorsGroupBootstrapComponent;
    @InjectMocks
    private BootstrapImporterModuleComponent importer;

    @Test
    public void alreadyBootstraped() throws Throwable {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(configNodeRef);
        this.importer.executeInternal();
        ((ImporterBootstrap)Mockito.verify((Object)this.mockedImporter, (VerificationMode)Mockito.never())).bootstrap();
        ((ModulePatchExecuter)Mockito.verify((Object)this.mockedModulePatchExecuter, (VerificationMode)Mockito.never())).initSchemaVersion();
        ((RecordContributorsGroupBootstrapComponent)Mockito.verify((Object)this.mockedRecordContributorsGroupBootstrapComponent, (VerificationMode)Mockito.never())).createRecordContributorsGroup();
    }

    @Test
    public void boostrap() throws Throwable {
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).exists(configNodeRef);
        this.importer.executeInternal();
        ((ImporterBootstrap)Mockito.verify((Object)this.mockedImporter, (VerificationMode)Mockito.times((int)1))).bootstrap();
        ((ModulePatchExecuter)Mockito.verify((Object)this.mockedModulePatchExecuter, (VerificationMode)Mockito.times((int)1))).initSchemaVersion();
        ((RecordContributorsGroupBootstrapComponent)Mockito.verify((Object)this.mockedRecordContributorsGroupBootstrapComponent, (VerificationMode)Mockito.times((int)1))).createRecordContributorsGroup();
    }
}

