/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.email;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.email.RFC822MetadataExtracter;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;

public class RFC822MetadataExtracterUnitTest
extends BaseUnitTest {
    @InjectMocks
    private RFC822MetadataExtracter metadataExtracter;
    private static final Map<QName, Serializable> COMMON_PROPERTIES = ImmutableMap.of((Object)ContentModel.PROP_NAME, (Object)"Name", (Object)ContentModel.PROP_TITLE, (Object)"Title");
    private static final Map<QName, Serializable> RECORD_PROPERTIES = ImmutableMap.of((Object)RecordsManagementModel.PROP_DECLARED_BY, (Object)"DeclaredBy", (Object)RecordsManagementModel.PROP_DECLARED_AT, (Object)new Date());
    private static final Map<QName, Serializable> DOD_PROPERTIES = ImmutableMap.of((Object)DOD5015Model.PROP_ORIGINATOR, (Object)"DODOriginator", (Object)DOD5015Model.PROP_ADDRESS, (Object)"Title");

    @Test
    public void testRemoveSensitivePropertiesFromCommonNodes() {
        NodeRef node = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.hasAspect(node, RecordsManagementModel.ASPECT_RECORD)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeService.hasAspect(node, DOD5015Model.ASPECT_DOD_5015_RECORD)).thenReturn((Object)false);
        HashMap<QName, Serializable> systemProperties = new HashMap<QName, Serializable>(COMMON_PROPERTIES);
        systemProperties.putAll(RECORD_PROPERTIES);
        systemProperties.putAll(DOD_PROPERTIES);
        this.metadataExtracter.filterSystemProperties(systemProperties, this.generateTargetProperties(node));
        Assert.assertTrue((String)"Sensitive properties were not properly filtered out.", (boolean)systemProperties.keySet().equals(COMMON_PROPERTIES.keySet()));
    }

    @Test
    public void testRemoveDodPropertiesFromRecordNodes() {
        NodeRef node = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.hasAspect(node, RecordsManagementModel.ASPECT_RECORD)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(node, DOD5015Model.ASPECT_DOD_5015_RECORD)).thenReturn((Object)false);
        HashMap<QName, Serializable> systemProperties = new HashMap<QName, Serializable>(COMMON_PROPERTIES);
        systemProperties.putAll(RECORD_PROPERTIES);
        systemProperties.putAll(DOD_PROPERTIES);
        this.metadataExtracter.filterSystemProperties(systemProperties, this.generateTargetProperties(node));
        Assert.assertTrue((String)"Common properties should not be filtered out from record nodes.", (boolean)systemProperties.keySet().containsAll(COMMON_PROPERTIES.keySet()));
        Assert.assertTrue((String)"Record properties should not be filtered out from record nodes.", (boolean)systemProperties.keySet().containsAll(RECORD_PROPERTIES.keySet()));
        Assert.assertFalse((String)"Sensitive DOD properties were not properly filtered out from record nodes.", (boolean)systemProperties.keySet().removeAll(DOD_PROPERTIES.keySet()));
    }

    @Test
    public void testRemoveRecordPropertiesFromDodNodes() {
        NodeRef node = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.hasAspect(node, RecordsManagementModel.ASPECT_RECORD)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeService.hasAspect(node, DOD5015Model.ASPECT_DOD_5015_RECORD)).thenReturn((Object)true);
        HashMap<QName, Serializable> systemProperties = new HashMap<QName, Serializable>(COMMON_PROPERTIES);
        systemProperties.putAll(RECORD_PROPERTIES);
        systemProperties.putAll(DOD_PROPERTIES);
        this.metadataExtracter.filterSystemProperties(systemProperties, this.generateTargetProperties(node));
        Assert.assertTrue((String)"Common properties should not be filtered out from DOD nodes.", (boolean)systemProperties.keySet().containsAll(COMMON_PROPERTIES.keySet()));
        Assert.assertTrue((String)"DOD properties should not be filtered out from DOD nodes.", (boolean)systemProperties.keySet().containsAll(DOD_PROPERTIES.keySet()));
        Assert.assertFalse((String)"Sensitive record properties were not properly filtered out from DOD nodes.", (boolean)systemProperties.keySet().removeAll(RECORD_PROPERTIES.keySet()));
    }

    private Map<QName, Serializable> generateTargetProperties(NodeRef node) {
        HashMap<QName, Serializable> targetProperties = new HashMap<QName, Serializable>();
        targetProperties.put(ContentModel.PROP_STORE_PROTOCOL, (Serializable)((Object)node.getStoreRef().getProtocol()));
        targetProperties.put(ContentModel.PROP_STORE_IDENTIFIER, (Serializable)((Object)node.getStoreRef().getIdentifier()));
        targetProperties.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)node.getId()));
        return targetProperties;
    }
}

