/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM1027Test
extends BaseRMTestCase {
    public void testCopyingAClosedFolder() throws Exception {
        final NodeRef recordFolder = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef recordFolder = RM1027Test.this.recordFolderService.createRecordFolder(RM1027Test.this.rmContainer, "My Closed Record Folder");
                RM1027Test.this.utils.closeFolder(recordFolder);
                TestCase.assertTrue((boolean)((Boolean)RM1027Test.this.nodeService.getProperty(recordFolder, RecordsManagementModel.PROP_IS_CLOSED)));
                return recordFolder;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                NodeRef destination = RM1027Test.this.filePlanService.createRecordCategory(RM1027Test.this.filePlan, "Copy Destination");
                FileInfo copyInfo = RM1027Test.this.fileFolderService.copy(recordFolder, destination, null);
                return copyInfo.getNodeRef();
            }

            public void test(NodeRef copy) throws Exception {
                TestCase.assertNotNull((Object)copy);
                TestCase.assertNotNull((Object)RM1027Test.this.nodeService.getProperty(copy, RecordsManagementModel.PROP_IDENTIFIER));
                TestCase.assertFalse((boolean)((Boolean)RM1027Test.this.nodeService.getProperty(copy, RecordsManagementModel.PROP_IS_CLOSED)));
            }
        });
    }

    public void testCopyingAFolderWithADispositionSchedule() throws Exception {
        final NodeRef recordFolder = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef recordFolder = RM1027Test.this.recordFolderService.createRecordFolder(RM1027Test.this.rmContainer, "My Closed Record Folder");
                TestCase.assertTrue((boolean)RM1027Test.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                return recordFolder;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                NodeRef destination = RM1027Test.this.filePlanService.createRecordCategory(RM1027Test.this.filePlan, "Copy Destination");
                FileInfo copyInfo = RM1027Test.this.fileFolderService.copy(recordFolder, destination, null);
                return copyInfo.getNodeRef();
            }

            public void test(NodeRef copy) throws Exception {
                TestCase.assertNotNull((Object)copy);
                TestCase.assertNotNull((Object)RM1027Test.this.nodeService.getProperty(copy, RecordsManagementModel.PROP_IDENTIFIER));
                TestCase.assertFalse((boolean)RM1027Test.this.nodeService.hasAspect(copy, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
            }
        });
    }
}

