/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import java.io.Serializable;
import java.util.HashSet;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;

public class CreateRecordTest
extends BaseRMTestCase {
    public void testCreateRecordCapabilityOnly() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            String roleName = GUID.generate();
            String user = GUID.generate();
            NodeRef recordFolder;
            NodeRef record;

            @Override
            public void given() {
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(CreateRecordTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(CreateRecordTest.this.capabilityService.getCapability("CreateRecords"));
                CreateRecordTest.this.filePlanRoleService.createRole(CreateRecordTest.this.filePlan, this.roleName, this.roleName, capabilities);
                CreateRecordTest.this.createPerson(this.user, true);
                CreateRecordTest.this.filePlanRoleService.assignRoleToAuthority(CreateRecordTest.this.filePlan, this.roleName, this.user);
                NodeRef rc = CreateRecordTest.this.filePlanService.createRecordCategory(CreateRecordTest.this.filePlan, GUID.generate());
                this.recordFolder = CreateRecordTest.this.recordFolderService.createRecordFolder(rc, GUID.generate());
            }

            @Override
            public void when() {
                CreateRecordTest.this.filePlanPermissionService.setPermission(this.recordFolder, this.user, "Filing");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        record = CreateRecordTest.this.recordService.createRecordFromContent(recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null);
                        return null;
                    }
                }, (String)this.user);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CreateRecordTest.this.recordService.isRecord(this.record));
            }
        });
    }

    public void testCreateRecordCapabilityOnlyFromFileFolderService() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            String roleName = GUID.generate();
            String user = GUID.generate();
            NodeRef recordFolder;
            NodeRef record;

            @Override
            public void given() {
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(CreateRecordTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(CreateRecordTest.this.capabilityService.getCapability("CreateRecords"));
                CreateRecordTest.this.filePlanRoleService.createRole(CreateRecordTest.this.filePlan, this.roleName, this.roleName, capabilities);
                CreateRecordTest.this.createPerson(this.user, true);
                CreateRecordTest.this.filePlanRoleService.assignRoleToAuthority(CreateRecordTest.this.filePlan, this.roleName, this.user);
                NodeRef rc = CreateRecordTest.this.filePlanService.createRecordCategory(CreateRecordTest.this.filePlan, GUID.generate());
                this.recordFolder = CreateRecordTest.this.recordFolderService.createRecordFolder(rc, GUID.generate());
            }

            @Override
            public void when() {
                CreateRecordTest.this.filePlanPermissionService.setPermission(this.recordFolder, this.user, "Filing");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        record = CreateRecordTest.this.fileFolderService.create(recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                        ContentWriter writer = CreateRecordTest.this.contentService.getWriter(record, ContentModel.TYPE_CONTENT, true);
                        writer.setMimetype("text/plain");
                        writer.setEncoding("UTF-8");
                        writer.putContent("Lucy Wetherall");
                        return null;
                    }
                }, (String)this.user);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CreateRecordTest.this.recordService.isRecord(this.record));
            }
        });
    }

    public void testCreateRecordCapabilityInsideUnfiledRecordsContainer() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            String roleName = GUID.generate();
            String user = GUID.generate();
            NodeRef record;

            @Override
            public void given() {
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(CreateRecordTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(CreateRecordTest.this.capabilityService.getCapability("CreateRecords"));
                capabilities.add(CreateRecordTest.this.capabilityService.getCapability("CreateModifyDestroyFileplanMetadata"));
                CreateRecordTest.this.filePlanRoleService.createRole(CreateRecordTest.this.filePlan, this.roleName, this.roleName, capabilities);
                CreateRecordTest.this.createPerson(this.user, true);
                CreateRecordTest.this.filePlanRoleService.assignRoleToAuthority(CreateRecordTest.this.filePlan, this.roleName, this.user);
                CreateRecordTest.this.filePlanPermissionService.setPermission(CreateRecordTest.this.unfiledContainer, this.user, "Filing");
                CreateRecordTest.this.filePlanPermissionService.setPermission(CreateRecordTest.this.unfiledContainer, this.user, "CreateModifyDestroyFileplanMetadata");
            }

            @Override
            public void when() {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        record = CreateRecordTest.this.recordService.createRecordFromContent(CreateRecordTest.this.unfiledContainer, GUID.generate(), ContentModel.TYPE_CONTENT, null, null);
                        return null;
                    }
                }, (String)this.user);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CreateRecordTest.this.recordService.isRecord(this.record));
            }
        });
    }

    public void testCreateRecordViaCoreServices() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            String roleName = GUID.generate();
            String user = GUID.generate();
            NodeRef recordFolder;
            NodeRef record;

            @Override
            public void given() {
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(CreateRecordTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(CreateRecordTest.this.capabilityService.getCapability("CreateRecords"));
                CreateRecordTest.this.filePlanRoleService.createRole(CreateRecordTest.this.filePlan, this.roleName, this.roleName, capabilities);
                CreateRecordTest.this.createPerson(this.user, true);
                CreateRecordTest.this.filePlanRoleService.assignRoleToAuthority(CreateRecordTest.this.filePlan, this.roleName, this.user);
                NodeRef rc = CreateRecordTest.this.filePlanService.createRecordCategory(CreateRecordTest.this.filePlan, GUID.generate());
                this.recordFolder = CreateRecordTest.this.recordFolderService.createRecordFolder(rc, GUID.generate());
            }

            @Override
            public void when() {
                CreateRecordTest.this.filePlanPermissionService.setPermission(this.recordFolder, this.user, "Filing");
                this.record = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        NodeRef record = CreateRecordTest.this.fileFolderService.create(recordFolder, "testRecord.txt", ContentModel.TYPE_CONTENT).getNodeRef();
                        ContentData content = (ContentData)CreateRecordTest.this.nodeService.getProperty(record, ContentModel.PROP_CONTENT);
                        CreateRecordTest.this.nodeService.setProperty(record, ContentModel.PROP_CONTENT, (Serializable)ContentData.setMimetype((ContentData)content, (String)"text/plain"));
                        return record;
                    }
                }, (String)this.user);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CreateRecordTest.this.recordService.isRecord(this.record));
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        try {
                            ContentData content = (ContentData)CreateRecordTest.this.nodeService.getProperty(record, ContentModel.PROP_CONTENT);
                            CreateRecordTest.this.nodeService.setProperty(record, ContentModel.PROP_CONTENT, (Serializable)ContentData.setMimetype((ContentData)content, (String)"text/plain"));
                            TestCase.fail((String)"Expecting access denied exception");
                        }
                        catch (AccessDeniedException accessDeniedException) {
                            // empty catch block
                        }
                        return null;
                    }
                }, (String)this.user);
            }
        });
    }
}

