/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RmPropertiesRestApiTest
extends BaseRMWebScriptTestCase {
    private static final String RM_TYPES_URL = "/api/rm/classes?cf=%s&siteId=%s";

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testRmGetTypeDefinitions() throws IOException, JSONException {
        String url = String.format(RM_TYPES_URL, "type", this.siteId);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        String contentAsString = response.getContentAsString();
        RmPropertiesRestApiTest.assertNotNull((Object)contentAsString);
        JSONArray contentAsJson = new JSONArray(contentAsString);
        RmPropertiesRestApiTest.assertNotNull((Object)contentAsJson);
        List<String> dmTypes = this.getDmTypes();
        List<String> rmTypes = this.getRmTypes();
        ArrayList<String> rmTypeList = new ArrayList<String>();
        for (int i = 0; i < contentAsJson.length(); ++i) {
            String name = contentAsJson.getJSONObject(i).getString("name");
            RmPropertiesRestApiTest.assertNotNull((Object)name);
            rmTypeList.add(name);
            RmPropertiesRestApiTest.assertFalse((boolean)dmTypes.contains(name));
        }
        RmPropertiesRestApiTest.assertTrue((boolean)rmTypeList.containsAll(rmTypes));
        url = String.format(RM_TYPES_URL, "type", this.collabSiteId);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        contentAsString = response.getContentAsString();
        RmPropertiesRestApiTest.assertNotNull((Object)contentAsString);
        contentAsJson = new JSONArray(contentAsString);
        RmPropertiesRestApiTest.assertNotNull((Object)contentAsJson);
        ArrayList<String> dmTypeList = new ArrayList<String>();
        for (int i = 0; i < contentAsJson.length(); ++i) {
            String name = contentAsJson.getJSONObject(i).getString("name");
            RmPropertiesRestApiTest.assertNotNull((Object)name);
            dmTypeList.add(name);
        }
        RmPropertiesRestApiTest.assertTrue((boolean)dmTypeList.containsAll(dmTypes));
        RmPropertiesRestApiTest.assertTrue((boolean)dmTypeList.containsAll(rmTypes));
    }

    private List<String> getRmTypes() {
        return Arrays.asList("rma:eventExecution", "rma:nonElectronicDocument", "rma:transfer");
    }

    private List<String> getDmTypes() {
        return Arrays.asList("cm:authority", "sys:descriptor", "app:folderlink", "wf:submitGroupReviewTask", "cmis:policy");
    }
}

