/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.workflow.RMWorkflowModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestInfoAction
extends RMActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(RequestInfoAction.class);
    public static final String PARAM_REQUESTED_INFO = "requestedInfo";
    public static final String PARAM_ASSIGNEES = "assignees";
    public static final String PARAM_RULE_CREATOR = "ruleCreator";
    public static final String NAME = "requestInfo";
    private static final String REQUEST_INFO_WORKFLOW_DEFINITION_NAME = "activiti$activitiRequestForInformation";
    private WorkflowService workflowService;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (this.getNodeService().exists(actionedUponNodeRef) && !this.getNodeService().hasAspect(actionedUponNodeRef, ContentModel.ASPECT_PENDING_DELETE) && this.getRecordService().isRecord(actionedUponNodeRef) && !this.getRecordService().isDeclared(actionedUponNodeRef)) {
            String workflowDefinitionId = this.workflowService.getDefinitionByName(REQUEST_INFO_WORKFLOW_DEFINITION_NAME).getId();
            HashMap<QName, Object> parameters = new HashMap<QName, Object>();
            parameters.put(WorkflowModel.ASSOC_PACKAGE, this.getWorkflowPackage(action, actionedUponNodeRef));
            parameters.put(RMWorkflowModel.RM_MIXED_ASSIGNEES, this.getAssignees(action));
            parameters.put(RMWorkflowModel.RM_REQUESTED_INFORMATION, this.getRequestedInformation(action));
            parameters.put(RMWorkflowModel.RM_RULE_CREATOR, this.getRuleCreator(action));
            this.workflowService.startWorkflow(workflowDefinitionId, parameters);
        } else {
            logger.info((Object)("Can't start the request information workflow for node '" + actionedUponNodeRef.toString() + "'."));
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_REQUESTED_INFO, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_REQUESTED_INFO)));
        paramList.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_ASSIGNEES, DataTypeDefinition.ANY, true, this.getParamDisplayLabel(PARAM_ASSIGNEES)));
        paramList.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_RULE_CREATOR, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_RULE_CREATOR)));
    }

    private NodeRef getWorkflowPackage(Action action, NodeRef actionedUponNodeRef) {
        NodeRef workflowPackage = (NodeRef)action.getParameterValue(WorkflowModel.ASSOC_PACKAGE.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
        workflowPackage = this.workflowService.createPackage(workflowPackage);
        ChildAssociationRef childAssoc = this.getNodeService().getPrimaryParent(actionedUponNodeRef);
        this.getNodeService().addChild(workflowPackage, actionedUponNodeRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, childAssoc.getQName());
        return workflowPackage;
    }

    private Serializable getAssignees(Action action) {
        String[] assignees;
        ArrayList<NodeRef> assigneesList = new ArrayList<NodeRef>();
        String assigneesAsString = (String)((Object)action.getParameterValue(PARAM_ASSIGNEES));
        for (String assignee : assignees = StringUtils.split((String)assigneesAsString, (char)',')) {
            assigneesList.add(new NodeRef(assignee));
        }
        return assigneesList;
    }

    private Serializable getRequestedInformation(Action action) {
        return action.getParameterValue(PARAM_REQUESTED_INFO);
    }

    private Serializable getRuleCreator(Action action) {
        return action.getParameterValue(PARAM_RULE_CREATOR);
    }
}

