/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.script.BaseTransferWebScript;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.content.ContentStreamer;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

@Deprecated
public class TransferReportGet
extends BaseTransferWebScript {
    private static Log logger = LogFactory.getLog(TransferReportGet.class);
    protected static final String REPORT_FILE_PREFIX = "report_";
    protected static final String REPORT_FILE_SUFFIX = ".json";
    protected DictionaryService ddService;
    protected DispositionService dispositionService;
    protected ContentStreamer contentStreamer;

    public void setDictionaryService(DictionaryService ddService) {
        this.ddService = ddService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setContentStreamer(ContentStreamer contentStreamer) {
        this.contentStreamer = contentStreamer;
    }

    @Override
    protected File executeTransfer(NodeRef transferNode, WebScriptRequest req, WebScriptResponse res, Status status, Cache cache) throws IOException {
        File report = this.generateJSONTransferReport(transferNode);
        this.contentStreamer.streamContent(req, res, report, null, false, null, null);
        return report;
    }

    File generateJSONTransferReport(NodeRef transferNode) throws IOException {
        File report = TempFileProvider.createTempFile((String)REPORT_FILE_PREFIX, (String)REPORT_FILE_SUFFIX);
        try (FileOutputStream fileOutputStream = new FileOutputStream(report);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));){
            DispositionSchedule ds;
            NodeRef[] itemsToTransfer = this.getTransferNodes(transferNode);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Generating JSON transfer report for " + itemsToTransfer.length + " items into file: " + report.getAbsolutePath()));
            }
            String dispositionAuthority = null;
            if (itemsToTransfer.length > 0 && (ds = this.dispositionService.getDispositionSchedule(itemsToTransfer[0])) != null) {
                dispositionAuthority = ds.getDispositionAuthority();
            }
            writer.write("{\n\t\"data\":\n\t{");
            writer.write("\n\t\t\"transferDate\": \"");
            writer.write(ISO8601DateFormat.format((Date)((Date)this.nodeService.getProperty(transferNode, ContentModel.PROP_CREATED))));
            writer.write("\",\n\t\t\"transferPerformedBy\": \"");
            writer.write(AuthenticationUtil.getRunAsUser());
            writer.write("\",\n\t\t\"dispositionAuthority\": \"");
            writer.write(dispositionAuthority != null ? dispositionAuthority : "");
            writer.write("\",\n\t\t\"items\":\n\t\t[");
            this.generateTransferItemsJSON(writer, itemsToTransfer);
            writer.write("\n\t\t]\n\t}\n}");
        }
        return report;
    }

    protected void generateTransferItemsJSON(Writer writer, NodeRef[] itemsToTransfer) throws IOException {
        boolean first = true;
        for (NodeRef item : itemsToTransfer) {
            if (first) {
                first = false;
            } else {
                writer.write(",");
            }
            if (this.ddService.isSubClass(this.nodeService.getType(item), ContentModel.TYPE_FOLDER)) {
                this.generateTransferFolderJSON(writer, item);
                continue;
            }
            this.generateTransferRecordJSON(writer, item);
        }
    }

    protected void generateTransferFolderJSON(Writer writer, NodeRef folderNode) throws IOException {
        writer.write("\n{\n\"type\":\"folder\",\n");
        writer.write("\"name\":\"");
        writer.write((String)((Object)this.nodeService.getProperty(folderNode, ContentModel.PROP_NAME)));
        writer.write("\",\n\"nodeRef\":\"");
        writer.write(folderNode.toString());
        writer.write("\",\n\"id\":\"");
        writer.write((String)((Object)this.nodeService.getProperty(folderNode, RecordsManagementModel.PROP_IDENTIFIER)));
        writer.write("\",\n\"children\":\n[");
        boolean first = true;
        List assocs = this.nodeService.getChildAssocs(folderNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef child : assocs) {
            if (first) {
                first = false;
            } else {
                writer.write(",");
            }
            NodeRef childRef = child.getChildRef();
            if (this.ddService.isSubClass(this.nodeService.getType(childRef), ContentModel.TYPE_FOLDER)) {
                this.generateTransferFolderJSON(writer, childRef);
                continue;
            }
            this.generateTransferRecordJSON(writer, childRef);
        }
        writer.write("\n]\n}");
    }

    protected void generateTransferRecordJSON(Writer writer, NodeRef recordNode) throws IOException {
        writer.write("\n{\n\"type\":\"record\",\n");
        writer.write("\"name\":\"");
        writer.write((String)((Object)this.nodeService.getProperty(recordNode, ContentModel.PROP_NAME)));
        writer.write("\",\n\"nodeRef\":\"");
        writer.write(recordNode.toString());
        writer.write("\",\n\"id\":\"");
        writer.write((String)((Object)this.nodeService.getProperty(recordNode, RecordsManagementModel.PROP_IDENTIFIER)));
        writer.write("\"");
        if (this.nodeService.hasAspect(recordNode, RecordsManagementModel.ASPECT_DECLARED_RECORD)) {
            writer.write(",\n\"declaredBy\":\"");
            writer.write((String)((Object)this.nodeService.getProperty(recordNode, RecordsManagementModel.PROP_DECLARED_BY)));
            writer.write("\",\n\"declaredAt\":\"");
            writer.write(ISO8601DateFormat.format((Date)((Date)this.nodeService.getProperty(recordNode, RecordsManagementModel.PROP_DECLARED_AT))));
            writer.write("\"");
        }
        writer.write("\n}");
    }
}

