/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.slingshot;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

public class SearchUtil {
    protected NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected Set<String> retrieveAllNodeIds(NodeRef nodeRef) {
        List childAssocRefs = this.nodeService.getChildAssocs(nodeRef);
        return childAssocRefs.stream().map(assoc -> assoc.getChildRef().getId()).collect(Collectors.toSet());
    }

    protected NodeRef getRootContainer(QName container) {
        NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        List assocRefs = this.nodeService.getChildAssocs(rootNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)container);
        if (assocRefs.isEmpty()) {
            return this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, container, ContentModel.TYPE_CONTAINER).getChildRef();
        }
        if (assocRefs.size() != 1) {
            throw new AlfrescoRuntimeException("Only one container is allowed.");
        }
        return ((ChildAssociationRef)assocRefs.iterator().next()).getChildRef();
    }
}

