/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.HoldContainerType;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.TransferContainerType;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.UnfiledRecordContainerType;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

@BehaviourBean(defaultType="rma:filePlan")
public class FilePlanType
extends BaseBehaviourBean
implements NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static final List<QName> ACCEPTED_UNIQUE_CHILD_TYPES = Arrays.asList(TYPE_HOLD_CONTAINER, TYPE_TRANSFER_CONTAINER, TYPE_UNFILED_RECORD_CONTAINER);
    private static final List<QName> ACCEPTED_NON_UNIQUE_CHILD_TYPES = Arrays.asList(TYPE_RECORD_CATEGORY);
    private static final String BEHAVIOUR_NAME = "onDeleteFilePlan";
    private FilePlanService filePlanService;
    private RecordFolderService recordFolderService;
    private IdentifierService identifierService;
    private FilePlanRoleService filePlanRoleService;
    private UnfiledRecordContainerType unfiledRecordContainerType;
    private TransferContainerType transferContainerType;
    private HoldContainerType holdContainerType;

    protected FilePlanService getFilePlanService() {
        return this.filePlanService;
    }

    protected RecordFolderService getRecordFolderService() {
        return this.recordFolderService;
    }

    protected IdentifierService getIdentifierService() {
        return this.identifierService;
    }

    protected FilePlanRoleService getFilePlanRoleService() {
        return this.filePlanRoleService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setIdentifierService(IdentifierService identifierService) {
        this.identifierService = identifierService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setUnfiledRecordContainerType(UnfiledRecordContainerType unfiledRecordContainerType) {
        this.unfiledRecordContainerType = unfiledRecordContainerType;
    }

    public void setTransferContainerType(TransferContainerType transferContainerType) {
        this.transferContainerType = transferContainerType;
    }

    public void setHoldContainerType(HoldContainerType holdContainerType) {
        this.holdContainerType = holdContainerType;
    }

    public void disable() {
        this.getBehaviour(BEHAVIOUR_NAME).disable();
    }

    public void enable() {
        this.getBehaviour(BEHAVIOUR_NAME).enable();
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION)
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean bNew) {
        if (this.nodeService.getType(childAssocRef.getChildRef()).equals((Object)ContentModel.TYPE_FOLDER)) {
            this.nodeService.setType(childAssocRef.getChildRef(), TYPE_RECORD_CATEGORY);
        }
        this.validateNewChildAssociation(childAssocRef.getParentRef(), childAssocRef.getChildRef(), ACCEPTED_UNIQUE_CHILD_TYPES, ACCEPTED_NON_UNIQUE_CHILD_TYPES);
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        final NodeRef filePlan = childAssocRef.getChildRef();
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                FilePlanType.this.nodeService.addAspect(filePlan, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
                if (FilePlanType.this.nodeService.getProperty(filePlan, RecordsManagementModel.PROP_IDENTIFIER) == null) {
                    String id = FilePlanType.this.getIdentifierService().generateIdentifier(filePlan);
                    FilePlanType.this.nodeService.setProperty(filePlan, RecordsManagementModel.PROP_IDENTIFIER, (Serializable)((Object)id));
                }
                return null;
            }
        });
        this.getFilePlanRoleService().setupFilePlanRoles(filePlan);
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT, name="onDeleteFilePlan")
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean archived) {
        this.unfiledRecordContainerType.enable();
        this.transferContainerType.enable();
        this.holdContainerType.enable();
        throw new IntegrityException("Operation failed. Deletion of File Plan is not allowed.", null);
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.unfiledRecordContainerType.disable();
        this.transferContainerType.disable();
        this.holdContainerType.disable();
    }

    @Behaviour(kind=BehaviourKind.CLASS, policy="alf:onDeleteNode", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onDeleteNodeOnCommit(ChildAssociationRef childAssocRef, boolean archived) {
        this.getFilePlanRoleService().tearDownFilePlanRoles(childAssocRef.getChildRef());
        this.unfiledRecordContainerType.enable();
        this.transferContainerType.enable();
        this.holdContainerType.enable();
    }
}

