/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.caveat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMCaveatConfigService;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public class RMListOfValuesConstraint
extends ListOfValuesConstraint {
    private static final String LOV_CONSTRAINT_VALUE = "listconstraint";
    private List<String> allowedValues;
    private List<String> allowedValuesUpper;
    private MatchLogic matchLogic = MatchLogic.AND;
    private static RMCaveatConfigService caveatConfigService;

    public void setCaveatConfigService(RMCaveatConfigService caveatConfigService) {
        RMListOfValuesConstraint.caveatConfigService = caveatConfigService;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("RMListOfValuesConstraint").append("[allowedValues=").append(this.getAllowedValues()).append(", caseSensitive=").append(this.isCaseSensitive()).append(", sorted=").append(this.isSorted()).append(", matchLogic=").append(this.getMatchLogic()).append("]");
        return sb.toString();
    }

    public RMListOfValuesConstraint() {
        this.sorted = true;
    }

    public List<String> getRawAllowedValues() {
        String runAsUser = AuthenticationUtil.getRunAsUser();
        if (runAsUser != null && !runAsUser.equals(AuthenticationUtil.getSystemUserName()) && caveatConfigService != null) {
            List<String> allowedForUser = caveatConfigService.getRMAllowedValues(this.getShortName());
            ArrayList<String> filteredList = new ArrayList<String>(allowedForUser.size());
            for (String allowed : allowedForUser) {
                if (!this.allowedValues.contains(allowed)) continue;
                filteredList.add(allowed);
            }
            return filteredList;
        }
        return this.allowedValues;
    }

    public String getDisplayLabel(String constraintAllowableValue, MessageLookup messageLookup) {
        if (!this.allowedValues.contains(constraintAllowableValue)) {
            return null;
        }
        Object key = LOV_CONSTRAINT_VALUE;
        key = (String)key + "." + this.getShortName();
        key = (String)key + "." + constraintAllowableValue;
        String message = messageLookup.getMessage((String)(key = StringUtils.replace((String)key, (String)":", (String)"_")), I18NUtil.getLocale());
        return message == null ? constraintAllowableValue : message;
    }

    private List<String> getAllowedValuesUpper() {
        String runAsUser = AuthenticationUtil.getRunAsUser();
        if (runAsUser != null && !runAsUser.equals(AuthenticationUtil.getSystemUserName()) && caveatConfigService != null) {
            List<String> allowedForUser = caveatConfigService.getRMAllowedValues(this.getType());
            ArrayList<String> filteredList = new ArrayList<String>(allowedForUser.size());
            for (String allowed : allowedForUser) {
                if (!this.allowedValuesUpper.contains(allowed.toUpperCase())) continue;
                filteredList.add(allowed);
            }
            return filteredList;
        }
        return this.allowedValuesUpper;
    }

    public void setAllowedValues(List allowedValues) {
        if (allowedValues == null) {
            allowedValues = new ArrayList(0);
        }
        int valueCount = allowedValues.size();
        this.allowedValues = Collections.unmodifiableList(allowedValues);
        this.allowedValuesUpper = new ArrayList<String>(valueCount);
        for (String allowedValue : this.allowedValues) {
            this.allowedValuesUpper.add(allowedValue.toUpperCase());
        }
    }

    public void initialize() {
        this.checkPropertyNotNull("allowedValues", this.allowedValues);
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("caseSensitive", this.isCaseSensitive());
        params.put("allowedValues", this.getAllowedValues());
        params.put("sorted", this.isSorted());
        params.put("matchLogic", this.getMatchLogic());
        return params;
    }

    public MatchLogic getMatchLogicEnum() {
        return this.matchLogic;
    }

    public String getMatchLogic() {
        return this.matchLogic.toString();
    }

    public void setMatchLogic(String matchLogicStr) {
        this.matchLogic = MatchLogic.valueOf(matchLogicStr);
    }

    protected void evaluateSingleValue(Object value) {
        String valueStr = null;
        try {
            valueStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, value);
        }
        catch (TypeConversionException e) {
            throw new ConstraintException("d_dictionary.constraint.string_length.non_string", new Object[]{value, e});
        }
        if (this.isCaseSensitive() ? !this.getAllowedValues().contains(valueStr) : !this.getAllowedValuesUpper().contains(valueStr.toUpperCase())) {
            throw new ConstraintException("d_dictionary.constraint.list_of_values.invalid_value", new Object[]{value});
        }
    }

    public static enum MatchLogic {
        AND,
        OR;

    }
}

