/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.io.Serializable;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.model.security.ModelAccessDeniedException;
import org.alfresco.module.org_alfresco_module_rm.model.security.ModelSecurityService;
import org.alfresco.module.org_alfresco_module_rm.model.security.ProtectedAspect;
import org.alfresco.module.org_alfresco_module_rm.model.security.ProtectedProperty;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class ModelSecurityServiceImplTest
extends BaseRMTestCase {
    private static final QName CUSTOM_ASPECT = QName.createQName((String)"http://www.alfresco.org/model/rmtest/1.0", (String)"customAspect");
    private static final QName CUSTOM_PROTECTED_ASPECT = QName.createQName((String)"http://www.alfresco.org/model/rmtest/1.0", (String)"customProtectedAspect");
    private static final QName CUSTOM_PROPERTY = QName.createQName((String)"http://www.alfresco.org/model/rmtest/1.0", (String)"customProperty");
    private static final QName CUSTOM_PROTECTED_PROPERTY = QName.createQName((String)"http://www.alfresco.org/model/rmtest/1.0", (String)"customProtectedProperty");
    private ModelSecurityService modelSecurityService;
    private boolean enabled;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isFillingForAllUsers() {
        return true;
    }

    @Override
    protected void initServices() {
        super.initServices();
        this.modelSecurityService = (ModelSecurityService)this.applicationContext.getBean("ModelSecurityService");
    }

    @Override
    protected void setupTestDataImpl() {
        super.setupTestDataImpl();
        this.enabled = this.modelSecurityService.isEnabled();
        this.modelSecurityService.setEnabled(true);
    }

    @Override
    protected void tearDownImpl() {
        super.tearDownImpl();
        this.modelSecurityService.setEnabled(this.enabled);
    }

    public void testProtectedAspects() throws Exception {
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                Set protectedAspects = ModelSecurityServiceImplTest.this.modelSecurityService.getProtectedAspects();
                TestCase.assertNotNull((Object)protectedAspects);
                TestCase.assertFalse((boolean)protectedAspects.isEmpty());
                TestCase.assertTrue((boolean)protectedAspects.contains(CUSTOM_PROTECTED_ASPECT));
                TestCase.assertFalse((boolean)protectedAspects.contains(CUSTOM_ASPECT));
                TestCase.assertTrue((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.isProtectedAspect(CUSTOM_PROTECTED_ASPECT));
                TestCase.assertFalse((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.isProtectedAspect(CUSTOM_ASPECT));
                ProtectedAspect protectedAspect = ModelSecurityServiceImplTest.this.modelSecurityService.getProtectedAspect(CUSTOM_ASPECT);
                TestCase.assertNull((Object)protectedAspect);
                protectedAspect = ModelSecurityServiceImplTest.this.modelSecurityService.getProtectedAspect(CUSTOM_PROTECTED_ASPECT);
                TestCase.assertNotNull((Object)protectedAspect);
                TestCase.assertNotNull((Object)protectedAspect.getQName());
                TestCase.assertNotNull((Object)protectedAspect.getCapabilities());
            }
        });
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertTrue((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.isProtectedAspect(CUSTOM_PROTECTED_ASPECT));
                TestCase.assertFalse((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.canEditProtectedAspect(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_ASPECT));
            }
        }, this.powerUserName);
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Normal rm user should not have the permissions to add the protected aspect.", ModelAccessDeniedException.class){

            public void run() throws Exception {
                ModelSecurityServiceImplTest.this.nodeService.addAspect(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_ASPECT, null);
            }
        }, this.powerUserName);
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertTrue((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.canEditProtectedAspect(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_ASPECT));
                ModelSecurityServiceImplTest.this.nodeService.addAspect(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_ASPECT, null);
                TestCase.assertTrue((boolean)ModelSecurityServiceImplTest.this.nodeService.hasAspect(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_ASPECT));
            }
        }, "admin");
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Normal rm user should not have the permissions to remove the custom aspect.", ModelAccessDeniedException.class){

            public void run() throws Exception {
                ModelSecurityServiceImplTest.this.nodeService.removeAspect(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_ASPECT);
            }
        }, this.powerUserName);
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                ModelSecurityServiceImplTest.this.nodeService.removeAspect(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_ASPECT);
                TestCase.assertFalse((boolean)ModelSecurityServiceImplTest.this.nodeService.hasAspect(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_ASPECT));
            }
        }, "admin");
    }

    public void testProtectedProperties() throws Exception {
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() {
                Set protectedProperties = ModelSecurityServiceImplTest.this.modelSecurityService.getProtectedProperties();
                TestCase.assertNotNull((Object)protectedProperties);
                TestCase.assertFalse((boolean)protectedProperties.isEmpty());
                TestCase.assertTrue((boolean)protectedProperties.contains(CUSTOM_PROTECTED_PROPERTY));
                TestCase.assertFalse((boolean)protectedProperties.contains(CUSTOM_PROPERTY));
                TestCase.assertTrue((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.isProtectedProperty(CUSTOM_PROTECTED_PROPERTY));
                TestCase.assertFalse((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.isProtectedProperty(CUSTOM_PROPERTY));
                ProtectedProperty protectedProperty = ModelSecurityServiceImplTest.this.modelSecurityService.getProtectedProperty(CUSTOM_PROPERTY);
                TestCase.assertNull((Object)protectedProperty);
                protectedProperty = ModelSecurityServiceImplTest.this.modelSecurityService.getProtectedProperty(CUSTOM_PROTECTED_PROPERTY);
                TestCase.assertNotNull((Object)protectedProperty);
                TestCase.assertNotNull((Object)protectedProperty.getQName());
                TestCase.assertNotNull((Object)protectedProperty.getCapabilities());
            }
        });
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertTrue((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.canEditProtectedProperty(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_PROPERTY));
            }
        }, "admin");
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertFalse((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.canEditProtectedProperty(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_PROPERTY));
            }
        }, this.powerUserName);
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertTrue((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.isProtectedProperty(CUSTOM_PROTECTED_PROPERTY));
                TestCase.assertFalse((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.canEditProtectedProperty(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_PROPERTY));
            }
        }, this.powerUserName);
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Should not have the permissions to edit protected property.", ModelAccessDeniedException.class){

            public void run() throws Exception {
                ModelSecurityServiceImplTest.this.nodeService.setProperty(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_PROPERTY, (Serializable)((Object)"hello"));
            }
        }, this.powerUserName);
        this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

            @Override
            public void runImpl() throws Exception {
                TestCase.assertTrue((boolean)ModelSecurityServiceImplTest.this.modelSecurityService.canEditProtectedProperty(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_PROPERTY));
                ModelSecurityServiceImplTest.this.nodeService.setProperty(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_PROPERTY, (Serializable)((Object)"hello"));
                TestCase.assertEquals((Object)"hello", (Object)ModelSecurityServiceImplTest.this.nodeService.getProperty(ModelSecurityServiceImplTest.this.rmFolder, CUSTOM_PROTECTED_PROPERTY));
            }
        }, "admin");
    }
}

