/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.search;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchParameters;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.search.SavedSearchDetails;
import org.alfresco.module.org_alfresco_module_rm.search.SortItem;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class SavedSearchDetailsCompatibility
implements RecordsManagementModel {
    private final SavedSearchDetails savedSearchDetails;
    private final NamespaceService namespaceService;
    private final RecordsManagementSearchServiceImpl searchService;

    public static String getSearchFromParams(String params) {
        String[] values;
        String search = null;
        for (String value : values = params.split("&")) {
            if (!value.startsWith("terms")) continue;
            String[] terms = value.trim().split("=");
            try {
                search = URLDecoder.decode(terms[1], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                search = null;
            }
            break;
        }
        return search;
    }

    public static RecordsManagementSearchParameters createSearchParameters(String params, String sort, NamespaceService namespaceService) {
        return SavedSearchDetailsCompatibility.createSearchParameters(params, new String[]{"&", "="}, sort, namespaceService);
    }

    public static RecordsManagementSearchParameters createSearchParameters(String params, String[] paramsDelim, String sort, NamespaceService namespaceService) {
        String[] values;
        RecordsManagementSearchParameters result = new RecordsManagementSearchParameters();
        ArrayList<QName> includedContainerTypes = new ArrayList<QName>(2);
        for (String value : values = params.split(paramsDelim[0])) {
            String[] paramValues = value.split(paramsDelim[1]);
            String paramName = paramValues[0].trim();
            String paramValue = paramValues[1].trim();
            if ("records".equals(paramName)) {
                result.setIncludeRecords(Boolean.parseBoolean(paramValue));
                continue;
            }
            if ("undeclared".equals(paramName)) {
                result.setIncludeUndeclaredRecords(Boolean.parseBoolean(paramValue));
                continue;
            }
            if ("vital".equals(paramName)) {
                result.setIncludeVitalRecords(Boolean.parseBoolean(paramValue));
                continue;
            }
            if ("folders".equals(paramName)) {
                result.setIncludeRecordFolders(Boolean.parseBoolean(paramValue));
                continue;
            }
            if ("frozen".equals(paramName)) {
                result.setIncludeFrozen(Boolean.parseBoolean(paramValue));
                continue;
            }
            if ("cutoff".equals(paramName)) {
                result.setIncludeCutoff(Boolean.parseBoolean(paramValue));
                continue;
            }
            if (!"categories".equals(paramName) || !Boolean.parseBoolean(paramValue)) continue;
            includedContainerTypes.add(TYPE_RECORD_CATEGORY);
        }
        result.setIncludedContainerTypes(includedContainerTypes);
        if (sort != null) {
            String[] sortPairs = sort.split(",");
            ArrayList<SortItem> sortOrder = new ArrayList<SortItem>(sortPairs.length);
            for (String sortPairString : sortPairs) {
                String[] sortPair = sortPairString.split("/");
                QName field = QName.createQName((String)sortPair[0], (NamespacePrefixResolver)namespaceService);
                Boolean isAcsending = Boolean.FALSE;
                if ("asc".equals(sortPair[1])) {
                    isAcsending = Boolean.TRUE;
                }
                sortOrder.add(new SortItem(field, isAcsending));
            }
            result.setSortOrder(sortOrder);
        }
        return result;
    }

    public SavedSearchDetailsCompatibility(SavedSearchDetails savedSearchDetails, NamespaceService namespaceService, RecordsManagementSearchServiceImpl searchService) {
        this.savedSearchDetails = savedSearchDetails;
        this.namespaceService = namespaceService;
        this.searchService = searchService;
    }

    public String getSort() {
        StringBuilder builder = new StringBuilder(64);
        for (SortItem entry : this.savedSearchDetails.getSearchParameters().getSortOrder()) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            String order = "desc";
            if (entry.assc) {
                order = "asc";
            }
            builder.append(entry.property.toPrefixString((NamespacePrefixResolver)this.namespaceService)).append("/").append(order);
        }
        return builder.toString();
    }

    public String getParams() {
        List<QName> includeContainerTypes = this.savedSearchDetails.getSearchParameters().getIncludedContainerTypes();
        StringBuilder builder = new StringBuilder(128);
        builder.append("terms=").append(this.savedSearchDetails.getSearch()).append("&").append("records=").append(this.savedSearchDetails.getSearchParameters().isIncludeRecords()).append("&").append("undeclared=").append(this.savedSearchDetails.getSearchParameters().isIncludeUndeclaredRecords()).append("&").append("vital=").append(this.savedSearchDetails.getSearchParameters().isIncludeVitalRecords()).append("&").append("folders=").append(this.savedSearchDetails.getSearchParameters().isIncludeRecordFolders()).append("&").append("frozen=").append(this.savedSearchDetails.getSearchParameters().isIncludeFrozen()).append("&").append("cutoff=").append(this.savedSearchDetails.getSearchParameters().isIncludeCutoff()).append("&").append("categories=").append(includeContainerTypes.contains(TYPE_RECORD_CATEGORY)).append("&").append("series=").append(false);
        return builder.toString();
    }

    public String getQuery() {
        return this.searchService.buildQueryString(this.savedSearchDetails.getSearch(), this.savedSearchDetails.getSearchParameters());
    }
}

