/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.disposition;

import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.model.RetentionSchedule;
import org.alfresco.rm.rest.api.model.RetentionScheduleActionDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;

public class RetentionScheduleModelUnitTest
extends BaseUnitTest {
    private static final String AUTHORITY = "authority";
    private static final String INSTRUCTIONS = "instructions";
    private static final String RETAIN_STEP = "retain";
    @InjectMocks
    private ApiNodesModelFactory apiNodesModelFactory;
    @Mock
    DispositionSchedule dispositionSchedule;
    @Mock
    DispositionActionDefinition dispositionActionDefinition;

    @Test
    public void mapRetentionScheduleDataTest() {
        NodeRef nodeRef = this.generateNodeRef(RecordsManagementModel.TYPE_DISPOSITION_SCHEDULE, true);
        ChildAssociationRef childAssociationRef = this.generateChildAssociationRef(this.filePlan, this.record);
        Mockito.when((Object)this.dispositionSchedule.getDispositionAuthority()).thenReturn((Object)AUTHORITY);
        Mockito.when((Object)this.dispositionSchedule.getDispositionInstructions()).thenReturn((Object)INSTRUCTIONS);
        Mockito.when((Object)this.dispositionSchedule.getNodeRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)this.dispositionSchedule.isRecordLevelDisposition()).thenReturn((Object)false);
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(nodeRef)).thenReturn((Object)childAssociationRef);
        RetentionSchedule actualResult = this.apiNodesModelFactory.mapRetentionScheduleData(this.dispositionSchedule);
        RetentionSchedule expectedResult = new RetentionSchedule();
        expectedResult.setId(nodeRef.getId());
        expectedResult.setParentId(this.filePlan.getId());
        expectedResult.setAuthority(AUTHORITY);
        expectedResult.setInstructions(INSTRUCTIONS);
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void mapRetentionScheduleActionDefDataTest() {
        NodeRef nodeRef = this.generateNodeRef(RecordsManagementModel.TYPE_DISPOSITION_SCHEDULE, true);
        String period = "month|10";
        ChildAssociationRef childAssociationRef = this.generateChildAssociationRef(this.filePlan, this.record);
        Mockito.when((Object)this.dispositionActionDefinition.getNodeRef()).thenReturn((Object)nodeRef);
        Mockito.when((Object)this.dispositionActionDefinition.getName()).thenReturn((Object)RETAIN_STEP);
        Mockito.when((Object)this.dispositionActionDefinition.getDescription()).thenReturn((Object)"Description");
        Mockito.when((Object)this.dispositionActionDefinition.getIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.dispositionActionDefinition.getGhostOnDestroy()).thenReturn((Object)"ghost");
        Mockito.when((Object)this.dispositionActionDefinition.getPeriod()).thenReturn((Object)new Period(period));
        Mockito.when((Object)this.dispositionActionDefinition.getLocation()).thenReturn((Object)"location");
        Mockito.when((Object)this.dispositionActionDefinition.getId()).thenReturn((Object)nodeRef.getId());
        Mockito.when((Object)this.mockedNodeService.getPrimaryParent(nodeRef)).thenReturn((Object)childAssociationRef);
        RetentionScheduleActionDefinition actualResult = this.apiNodesModelFactory.mapRetentionScheduleActionDefData(this.dispositionActionDefinition);
        RetentionScheduleActionDefinition expectedResult = RetentionScheduleModelUnitTest.getRetentionScheduleActionDefinition(nodeRef);
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    private static RetentionScheduleActionDefinition getRetentionScheduleActionDefinition(NodeRef nodeRef) {
        RetentionScheduleActionDefinition expectedResult = new RetentionScheduleActionDefinition();
        expectedResult.setId(nodeRef.getId());
        expectedResult.setName(RETAIN_STEP);
        expectedResult.setDescription("Description");
        expectedResult.setIndex(1);
        expectedResult.setLocation("location");
        expectedResult.setPeriod("month");
        expectedResult.setPeriodAmount(10);
        expectedResult.setRetainRecordMetadataAfterDestruction(true);
        return expectedResult;
    }
}

