/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.disposition;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.job.publish.DispositionActionDefinitionPublishExecutor;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.bdt.BehaviourTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.extensions.webscripts.GUID;

public class UpdateDispositionScheduleTest
extends BaseRMTestCase {
    protected static final String TEST_PREFIX = UpdateDispositionScheduleTest.class.getName() + GUID.generate() + "_";
    protected static final String CATEGORY_NAME = TEST_PREFIX + "Category";
    protected static final String FOLDER_NAME = TEST_PREFIX + "Folder";
    protected static final String RECORD_NAME = TEST_PREFIX + "Record";
    private DispositionActionDefinitionPublishExecutor dispositionActionDefinitionPublishExecutor;
    private DispositionService internalDispositionService;
    private NodeRef category;
    private NodeRef folder;
    private NodeRef record;
    private Date originalAsOfDate;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        BehaviourTest.initBehaviourTests(this.retryingTransactionHelper);
        this.applicationContext = ApplicationContextHelper.getApplicationContext((String[])this.getConfigLocations());
        this.dispositionActionDefinitionPublishExecutor = (DispositionActionDefinitionPublishExecutor)this.applicationContext.getBean(DispositionActionDefinitionPublishExecutor.class);
        this.internalDispositionService = (DispositionService)this.applicationContext.getBean("dispositionService");
    }

    public void testUpdatePeriod() {
        BehaviourTest.test().given(() -> {
            this.category = this.filePlanService.createRecordCategory(this.filePlan, CATEGORY_NAME);
            DispositionSchedule dispSched = this.utils.createBasicDispositionSchedule(this.category, "instructions", "authority", true, false);
            ImmutableMap cutOffParams = ImmutableMap.of((Object)PROP_DISPOSITION_ACTION_NAME, (Object)"cutoff", (Object)PROP_DISPOSITION_DESCRIPTION, (Object)"description", (Object)PROP_DISPOSITION_PERIOD, (Object)"immediately|0");
            this.dispositionService.addDispositionActionDefinition(dispSched, (Map)cutOffParams);
            ImmutableMap destroyParams = ImmutableMap.of((Object)PROP_DISPOSITION_ACTION_NAME, (Object)"destroy", (Object)PROP_DISPOSITION_DESCRIPTION, (Object)"description", (Object)PROP_DISPOSITION_PERIOD, (Object)"year|1", (Object)PROP_DISPOSITION_PERIOD_PROPERTY, (Object)ContentModel.PROP_CREATED);
            this.dispositionService.addDispositionActionDefinition(dispSched, (Map)destroyParams);
            this.folder = this.recordFolderService.createRecordFolder(this.category, FOLDER_NAME);
            this.record = this.fileFolderService.create(this.folder, RECORD_NAME, ContentModel.TYPE_CONTENT).getNodeRef();
            this.dispositionService.cutoffDisposableItem(this.record);
            this.internalDispositionService.updateNextDispositionAction(this.record);
            this.originalAsOfDate = this.dispositionService.getNextDispositionAction(this.record).getAsOfDate();
        }).when(() -> {
            DispositionSchedule dispSched = this.dispositionService.getDispositionSchedule(this.category);
            DispositionActionDefinition destroy = dispSched.getDispositionActionDefinitionByName("destroy");
            ImmutableMap destroyParams = ImmutableMap.of((Object)PROP_DISPOSITION_ACTION_NAME, (Object)"destroy", (Object)PROP_DISPOSITION_DESCRIPTION, (Object)"description", (Object)PROP_DISPOSITION_PERIOD, (Object)"year|3", (Object)PROP_DISPOSITION_PERIOD_PROPERTY, (Object)ContentModel.PROP_CREATED);
            this.dispositionService.updateDispositionActionDefinition(destroy, (Map)destroyParams);
            this.dispositionActionDefinitionPublishExecutor.publish(destroy.getNodeRef());
        }).then().expect(true).from(() -> this.aboutTwoYearsApart(this.originalAsOfDate, this.dispositionService.getNextDispositionAction(this.record).getAsOfDate())).because("Increasing the destroy period by two years should increase the 'as of' date by two years.");
    }

    private boolean aboutTwoYearsApart(Date start, Date end) {
        long yearInDays = 365L;
        long days = this.daysBetween(start, end);
        return yearInDays < days && days < 3L * yearInDays;
    }

    private long daysBetween(Date start, Date end) {
        return TimeUnit.MILLISECONDS.toDays(end.getTime() - start.getTime());
    }
}

