/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.junit.Assert;
import org.springframework.context.ApplicationContext;

public class UserAndGroupsUtils {
    protected FilePlanRoleService filePlanRoleService;
    protected AuthorityService authorityService;

    public UserAndGroupsUtils(ApplicationContext applicationContext) {
        this.filePlanRoleService = (FilePlanRoleService)applicationContext.getBean("FilePlanRoleService");
        this.authorityService = (AuthorityService)applicationContext.getBean("AuthorityService");
    }

    public void addUserToRole(NodeRef filePlan, String userName, RMRole role) {
        Role roleObj = this.filePlanRoleService.getRole(filePlan, role.getGroupName());
        Assert.assertNotNull((String)("Notification role " + role.getGroupName() + " could not be retrieved"), (Object)roleObj);
        String roleGroup = roleObj.getRoleGroupName();
        Assert.assertNotNull((String)("Notification role group " + roleGroup + " can not be null."), (Object)roleGroup);
        this.authorityService.addAuthority(roleGroup, userName);
    }

    public static enum RMRole {
        RM_ADMINISTRATOR("Administrator"),
        RM_MANAGER("RecordsManager"),
        RM_POWER_USER("PowerUser"),
        RM_SECURITY_OFFICER("SecurityOfficer"),
        RM_USER("User");

        private String groupName;

        private RMRole(String groupName) {
            this.groupName = groupName;
        }

        public String getGroupName() {
            return this.groupName;
        }
    }
}

