/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.slingshot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RMSearchPropertiesGet
extends DeclarativeWebScript {
    private RecordsManagementAdminService adminService;
    private RecordService recordService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private FilePlanService filePlanService;

    public void setAdminService(RecordsManagementAdminService adminService) {
        this.adminService = adminService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(13);
        ArrayList<Group> groups = new ArrayList<Group>(5);
        NodeRef filePlan = this.filePlanService.getFilePlanBySiteId("rm");
        Set<QName> aspects = this.recordService.getRecordMetadataAspects(filePlan);
        for (QName aspect : aspects) {
            Map properties = this.dictionaryService.getPropertyDefs(aspect);
            Property[] propObjs = new Property[properties.size()];
            int index = 0;
            for (PropertyDefinition propertyDefinition : properties.values()) {
                Property propObj = new Property(propertyDefinition);
                propObjs[index] = propObj;
                ++index;
            }
            AspectDefinition aspectDefinition = this.dictionaryService.getAspect(aspect);
            Group group = new Group(aspect.getLocalName(), aspectDefinition.getTitle((MessageLookup)this.dictionaryService), propObjs);
            groups.add(group);
        }
        Map<QName, PropertyDefinition> customProps = this.adminService.getCustomPropertyDefinitions();
        Property[] propObjs = new Property[customProps.size()];
        int index = 0;
        for (PropertyDefinition propertyDefinition : customProps.values()) {
            Property propObj;
            propObjs[index] = propObj = new Property(propertyDefinition);
            ++index;
        }
        Group group = new Group("rmcustom", "Custom", propObjs);
        groups.add(group);
        model.put("groups", groups);
        return model;
    }

    public class Property {
        private String prefix;
        private String shortName;
        private String label;
        private String type;

        public Property(PropertyDefinition propertyDefinition) {
            QName qName = propertyDefinition.getName().getPrefixedQName((NamespacePrefixResolver)RMSearchPropertiesGet.this.namespaceService);
            this.prefix = QName.splitPrefixedQName((String)qName.toPrefixString())[0];
            this.shortName = qName.getLocalName();
            this.label = propertyDefinition.getTitle((MessageLookup)RMSearchPropertiesGet.this.dictionaryService);
            this.type = propertyDefinition.getDataType().getName().getLocalName();
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }
    }

    public class Group {
        private String id;
        private String label;
        private Property[] properties;

        public Group(String id, String label, Property[] properties) {
            this.id = id;
            this.label = label;
            this.properties = (Property[])properties.clone();
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public Property[] getProperties() {
            return this.properties;
        }
    }
}

