/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.aspect;

import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.Relationship;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.util.ContentBinDuplicationUtility;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.namespace.QName;

@BehaviourBean(defaultType="rmv:versionRecord")
public class VersionRecordAspect
extends BaseBehaviourBean
implements NodeServicePolicies.BeforeAddAspectPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private RecordableVersionService recordableVersionService;
    private RelationshipService relationshipService;
    private ContentBinDuplicationUtility contentBinDuplicationUtility;

    public void setRecordableVersionService(RecordableVersionService recordableVersionService) {
        this.recordableVersionService = recordableVersionService;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    public void setContentBinDuplicationUtility(ContentBinDuplicationUtility contentBinDuplicationUtility) {
        this.contentBinDuplicationUtility = contentBinDuplicationUtility;
    }

    @Behaviour(kind=BehaviourKind.CLASS)
    public void beforeDeleteNode(final NodeRef nodeRef) {
        final Version version = this.recordableVersionService.getRecordedVersion(nodeRef);
        if (version != null) {
            this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void doWork() {
                    VersionRecordAspect.this.behaviourFilter.disableBehaviour();
                    try {
                        Set<Relationship> froms;
                        VersionRecordAspect.this.recordableVersionService.destroyRecordedVersion(version);
                        Set<Relationship> tos = VersionRecordAspect.this.relationshipService.getRelationshipsTo(nodeRef, "versions");
                        if (!tos.isEmpty() && tos.size() == 1 && !(froms = VersionRecordAspect.this.relationshipService.getRelationshipsFrom(nodeRef, "versions")).isEmpty()) {
                            Relationship to = tos.iterator().next();
                            for (Relationship from : froms) {
                                VersionRecordAspect.this.relationshipService.addRelationship("versions", to.getSource(), from.getTarget());
                            }
                        }
                    }
                    finally {
                        VersionRecordAspect.this.behaviourFilter.enableBehaviour();
                    }
                    return null;
                }
            });
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void beforeAddAspect(NodeRef nodeRef, QName qName) {
        if (!this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_RECORD_ORIGINATING_DETAILS)) {
            this.contentBinDuplicationUtility.duplicate(nodeRef);
        }
    }
}

