/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.workflow.requestInfo;

import java.util.ArrayList;
import java.util.Map;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNodeList;
import org.alfresco.util.ParameterCheck;
import org.alfresco.workflow.requestInfo.RequestInfoUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public class RequestInfoAssignmentHandler
implements TaskListener {
    private static final long serialVersionUID = -3179929030094957978L;

    public void notify(DelegateTask delegateTask) {
        ParameterCheck.mandatory((String)"delegateTask", (Object)delegateTask);
        delegateTask.setVariable("bpm_workflowDescription", (Object)this.getWorkflowDescription(RequestInfoUtils.getRecordName(delegateTask)));
        ActivitiScriptNodeList usersAndGroups = (ActivitiScriptNodeList)delegateTask.getVariable("rmwf_mixedAssignees");
        if (usersAndGroups == null) {
            throw new AlfrescoRuntimeException("It was not possible to extract the user(s) and/or group(s)!!!");
        }
        ArrayList<String> candidateUsers = new ArrayList<String>();
        ArrayList<String> candidateGroups = new ArrayList<String>();
        for (ActivitiScriptNode activitiScriptNode : usersAndGroups) {
            String type = activitiScriptNode.getType();
            Map properties = activitiScriptNode.getProperties();
            if (type.equalsIgnoreCase(ContentModel.TYPE_PERSON.toString())) {
                candidateUsers.add((String)properties.get(ContentModel.PROP_USERNAME.toString()));
                continue;
            }
            if (type.equalsIgnoreCase(ContentModel.TYPE_AUTHORITY_CONTAINER.toString())) {
                candidateGroups.add((String)properties.get(ContentModel.PROP_AUTHORITY_NAME.toString()));
                continue;
            }
            throw new AlfrescoRuntimeException("The type '" + type + "' is neither a user nor a group!!!");
        }
        if (candidateUsers.size() == 0 && candidateGroups.size() == 0) {
            throw new AlfrescoRuntimeException("Neither a user nor a group was found!!!");
        }
        if (candidateUsers.size() > 0) {
            delegateTask.addCandidateUsers(candidateUsers);
        }
        if (candidateGroups.size() > 0) {
            delegateTask.addCandidateGroups(candidateGroups);
        }
    }

    private String getWorkflowDescription(String recordName) {
        StringBuilder sb = new StringBuilder();
        sb.append(I18NUtil.getMessage((String)"activitiReviewPooled.workflow.info.requested"));
        sb.append(" '");
        sb.append(recordName);
        sb.append("'");
        return sb.toString();
    }
}

