/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.dm;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.BaseActionUnitTest;
import org.alfresco.module.org_alfresco_module_rm.action.dm.DeclareAsVersionRecordAction;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.version.RecordableVersionService;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.extensions.webscripts.GUID;

public class DeclareAsVersionRecordActionUnitTest
extends BaseActionUnitTest {
    private static final String SYNC_MODEL_1_0_URI = "http://www.alfresco.org/model/sync/1.0";
    private static final QName ASPECT_SYNCED = QName.createQName((String)"http://www.alfresco.org/model/sync/1.0", (String)"synced");
    private NodeRef actionedUponNodeRef;
    private NodeRef destinationRecordFolderNodeRef;
    private NodeRef parentDestinationNodeRef;
    @InjectMocks
    private DeclareAsVersionRecordAction declareAsVersionRecordAction;
    @Mock
    private CapabilityService mockedCapabilityService;

    @Override
    public void before() throws Exception {
        super.before();
        this.declareAsVersionRecordAction.setAuditable(false);
        this.actionedUponNodeRef = this.generateNodeRef();
        this.destinationRecordFolderNodeRef = this.generateNodeRef();
        this.parentDestinationNodeRef = this.generateNodeRef();
    }

    @Test
    public void actionedUponNodeRefDoesntExist() {
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).exists(this.actionedUponNodeRef);
        this.declareAsVersionRecordAction.executeImpl((Action)Mockito.mock(Action.class), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.never())).createRecordFromLatestVersion(this.filePlan, this.actionedUponNodeRef);
    }

    @Test
    public void aciontedUponNodeRefIsntSubTypeOfCmContent() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.actionedUponNodeRef);
        ((DictionaryService)Mockito.doReturn((Object)false).when((Object)this.mockedDictionaryService)).isSubClass((QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)ContentModel.TYPE_CONTENT));
        this.declareAsVersionRecordAction.executeImpl((Action)Mockito.mock(Action.class), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.never())).createRecordFromLatestVersion(this.filePlan, this.actionedUponNodeRef);
    }

    @Test
    public void actionedUponNodeRefDoesntHaveVersionableApplied() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.actionedUponNodeRef);
        ((DictionaryService)Mockito.doReturn((Object)true).when((Object)this.mockedDictionaryService)).isSubClass((QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)ContentModel.TYPE_CONTENT));
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE);
        this.declareAsVersionRecordAction.executeImpl((Action)Mockito.mock(Action.class), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.never())).createRecordFromLatestVersion(this.filePlan, this.actionedUponNodeRef);
    }

    @Test
    public void actionedUponNodeRefAlreadyRecord() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.actionedUponNodeRef);
        ((DictionaryService)Mockito.doReturn((Object)true).when((Object)this.mockedDictionaryService)).isSubClass((QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)ContentModel.TYPE_CONTENT));
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_RECORD);
        this.declareAsVersionRecordAction.executeImpl((Action)Mockito.mock(Action.class), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.never())).createRecordFromLatestVersion(this.filePlan, this.actionedUponNodeRef);
    }

    @Test
    public void actionedUponNodeRefWorkingCopy() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.actionedUponNodeRef);
        ((DictionaryService)Mockito.doReturn((Object)true).when((Object)this.mockedDictionaryService)).isSubClass((QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)ContentModel.TYPE_CONTENT));
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_RECORD);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_WORKING_COPY);
        this.declareAsVersionRecordAction.executeImpl((Action)Mockito.mock(Action.class), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.never())).createRecordFromLatestVersion(this.filePlan, this.actionedUponNodeRef);
    }

    @Test
    public void actionedUponNodeRefRejectedRecord() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.actionedUponNodeRef);
        ((DictionaryService)Mockito.doReturn((Object)true).when((Object)this.mockedDictionaryService)).isSubClass((QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)ContentModel.TYPE_CONTENT));
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_RECORD);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_WORKING_COPY);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_RECORD_REJECTION_DETAILS);
        this.declareAsVersionRecordAction.executeImpl((Action)Mockito.mock(Action.class), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.never())).createRecordFromLatestVersion(this.filePlan, this.actionedUponNodeRef);
    }

    @Test
    public void actionedUponNodeRefSynced() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.actionedUponNodeRef);
        ((DictionaryService)Mockito.doReturn((Object)true).when((Object)this.mockedDictionaryService)).isSubClass((QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)ContentModel.TYPE_CONTENT));
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_RECORD);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_WORKING_COPY);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_RECORD_REJECTION_DETAILS);
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_SYNCED);
        this.declareAsVersionRecordAction.executeImpl((Action)Mockito.mock(Action.class), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.never())).createRecordFromLatestVersion(this.filePlan, this.actionedUponNodeRef);
    }

    @Test
    public void noFilePlanParameterNoDefaultFilePlan() {
        this.setupMockedAspects();
        ((FilePlanService)Mockito.doReturn(null).when((Object)this.mockedFilePlanService)).getFilePlanBySiteId("rm");
        this.exception.expect(AlfrescoRuntimeException.class);
        this.declareAsVersionRecordAction.executeImpl((Action)Mockito.mock(Action.class), this.actionedUponNodeRef);
    }

    @Test
    public void noFilePlanParameterDefaultFilePlan() {
        this.setupMockedAspects();
        ((FilePlanService)Mockito.doReturn((Object)this.filePlan).when((Object)this.mockedFilePlanService)).getFilePlanBySiteId("rm");
        this.declareAsVersionRecordAction.executeImpl((Action)Mockito.mock(Action.class), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.times((int)1))).createRecordFromLatestVersion(this.filePlan, this.actionedUponNodeRef);
    }

    @Test
    public void invalidFilePlanParameter() {
        this.setupMockedAspects();
        this.mockActionParameterValue("file-plan", this.generateNodeRef());
        this.exception.expect(AlfrescoRuntimeException.class);
        this.declareAsVersionRecordAction.executeImpl(this.getMockedAction(), this.actionedUponNodeRef);
    }

    @Test
    public void validFilePlanParameter() {
        this.setupMockedAspects();
        NodeRef myFilePlan = this.generateNodeRef(TYPE_FILE_PLAN);
        ((FilePlanService)Mockito.doReturn((Object)true).when((Object)this.mockedFilePlanService)).isFilePlan(myFilePlan);
        this.mockActionParameterValue("file-plan", myFilePlan);
        this.declareAsVersionRecordAction.executeImpl(this.getMockedAction(), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.times((int)1))).createRecordFromLatestVersion(myFilePlan, this.actionedUponNodeRef);
    }

    @Test
    public void validDestinationRecordFolderProvided() {
        String pathParameter = GUID.generate();
        this.setupMockedAspects();
        this.mockActionParameterValue("path", pathParameter);
        ((NodeService)Mockito.doReturn((Object)this.destinationRecordFolderNodeRef).when((Object)this.mockedNodeService)).getChildByName(this.filePlan, ContentModel.ASSOC_CONTAINS, pathParameter);
        ((NodeService)Mockito.doReturn((Object)TYPE_RECORD_FOLDER).when((Object)this.mockedNodeService)).getType(this.destinationRecordFolderNodeRef);
        ((CapabilityService)Mockito.doReturn((Object)true).when((Object)this.mockedCapabilityService)).hasCapability(this.destinationRecordFolderNodeRef, "FileVersionRecords");
        ((FilePlanService)Mockito.doReturn((Object)this.filePlan).when((Object)this.mockedFilePlanService)).getFilePlanBySiteId("rm");
        this.declareAsVersionRecordAction.executeImpl(this.getMockedAction(), this.actionedUponNodeRef);
        ((RecordableVersionService)Mockito.verify((Object)this.mockedRecordableVersionService, (VerificationMode)Mockito.times((int)1))).createRecordFromLatestVersion(this.destinationRecordFolderNodeRef, this.actionedUponNodeRef);
    }

    @Test
    public void invalidDestinationRecordFolderProvided() {
        String childName = GUID.generate();
        this.setupMockedAspects();
        ((NodeService)Mockito.doReturn((Object)this.destinationRecordFolderNodeRef).when((Object)this.mockedNodeService)).getChildByName(this.parentDestinationNodeRef, ContentModel.ASSOC_CONTAINS, childName);
        ((NodeService)Mockito.doReturn((Object)TYPE_RECORD_FOLDER).when((Object)this.mockedNodeService)).getType(this.destinationRecordFolderNodeRef);
        ((CapabilityService)Mockito.doReturn((Object)false).when((Object)this.mockedCapabilityService)).hasCapability(this.destinationRecordFolderNodeRef, "EditRecordMetadata");
        this.exception.expect(AlfrescoRuntimeException.class);
        this.declareAsVersionRecordAction.executeImpl(this.getMockedAction(), this.actionedUponNodeRef);
    }

    private void setupMockedAspects() {
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).exists(this.actionedUponNodeRef);
        ((DictionaryService)Mockito.doReturn((Object)true).when((Object)this.mockedDictionaryService)).isSubClass((QName)ArgumentMatchers.nullable(QName.class), (QName)ArgumentMatchers.eq((Object)ContentModel.TYPE_CONTENT));
        ((NodeService)Mockito.doReturn((Object)true).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_RECORD);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ContentModel.ASPECT_WORKING_COPY);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_RECORD_REJECTION_DETAILS);
        ((NodeService)Mockito.doReturn((Object)false).when((Object)this.mockedNodeService)).hasAspect(this.actionedUponNodeRef, ASPECT_SYNCED);
    }
}

