/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.jscript.app.JSONConversionComponent;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM2192Test
extends BaseRMTestCase {
    private static final String PATH = "/111/222/333";
    private RuleService ruleService;
    private JSONConversionComponent converter;
    private NodeRef folder;
    private String user;
    private NodeRef documentLibrary2;

    @Override
    protected void initServices() {
        super.initServices();
        this.ruleService = (RuleService)this.applicationContext.getBean("RuleService");
        this.converter = (JSONConversionComponent)this.applicationContext.getBean("jsonConversionComponent");
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupCollaborationSiteTestDataImpl() {
        super.setupCollaborationSiteTestDataImpl();
        String collabSiteId2 = GUID.generate();
        this.siteService.createSite("site-dashboard", collabSiteId2, GUID.generate(), GUID.generate(), SiteVisibility.PUBLIC);
        this.documentLibrary2 = SiteServiceImpl.getSiteContainer((String)collabSiteId2, (String)"documentLibrary", (boolean)true, (SiteService)this.siteService, (TransactionService)this.transactionService, (TaggingService)this.taggingService);
        RM2192Test.assertNotNull((String)"Collaboration site document library component was not successfully created.", (Object)this.documentLibrary2);
        this.user = GUID.generate();
        this.createPerson(this.user);
        this.siteService.setMembership(collabSiteId2, this.user, "SiteManager");
        this.filePlanRoleService.assignRoleToAuthority(this.filePlan, "RecordsManager", this.user);
    }

    public void testAccessToRecordAfterDeclaring() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM2192Test.this.folder = RM2192Test.this.fileFolderService.create(RM2192Test.this.documentLibrary2, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                Action createAction = RM2192Test.this.actionService.createAction("create-record");
                createAction.setParameterValue("file-plan", (Serializable)RM2192Test.this.filePlan);
                Rule declareRule = new Rule();
                declareRule.setRuleType("inbound");
                declareRule.setTitle(GUID.generate());
                declareRule.setAction(createAction);
                declareRule.setExecuteAsynchronously(true);
                declareRule.applyToChildren(true);
                RM2192Test.this.ruleService.saveRule(RM2192Test.this.folder, declareRule);
                Action fileAction = RM2192Test.this.actionService.createAction("fileTo");
                fileAction.setParameterValue("path", (Serializable)((Object)RM2192Test.PATH));
                fileAction.setParameterValue("createRecordPath", (Serializable)Boolean.valueOf(true));
                Rule fileRule = new Rule();
                fileRule.setRuleType("inbound");
                fileRule.setTitle(GUID.generate());
                fileRule.setAction(fileAction);
                fileRule.setExecuteAsynchronously(true);
                RM2192Test.this.ruleService.saveRule(RM2192Test.this.unfiledContainer, fileRule);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertFalse((boolean)RM2192Test.this.ruleService.getRules(RM2192Test.this.folder).isEmpty());
                TestCase.assertFalse((boolean)RM2192Test.this.ruleService.getRules(RM2192Test.this.unfiledContainer).isEmpty());
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){
            NodeRef document;

            public Void run() {
                this.document = RM2192Test.this.fileFolderService.create(RM2192Test.this.folder, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                return null;
            }

            public void test(Void result) throws InterruptedException {
                Thread.sleep(10000L);
                TestCase.assertEquals((Object)RM2192Test.this.permissionService.hasPermission(this.document, "ReadRecords"), (Object)AccessStatus.ALLOWED);
                TestCase.assertTrue((boolean)RM2192Test.this.recordService.isFiled(this.document));
                TestCase.assertNotNull((Object)RM2192Test.this.converter.toJSON(this.document, true));
            }
        }, this.user);
    }
}

