/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.recordfolder;

import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.extensions.webscripts.GUID;

public class MoveRecordFolderTest
extends BaseRMTestCase {
    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testMoveRecordFolderBeforeCutOffFolderLevelDisposition() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(null, false){
            NodeRef recordFolder;
            NodeRef destinationRecordCategory;

            @Override
            public void given() {
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        NodeRef rcOne = MoveRecordFolderTest.this.createRecordCategory(false);
                        destinationRecordCategory = MoveRecordFolderTest.this.createRecordCategory(false);
                        recordFolder = MoveRecordFolderTest.this.recordFolderService.createRecordFolder(rcOne, GUID.generate());
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                        DispositionAction dispositionAction = MoveRecordFolderTest.this.dispositionService.getNextDispositionAction(recordFolder);
                        TestCase.assertNotNull((Object)dispositionAction);
                        TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                        TestCase.assertNotNull((Object)dispositionAction.getAsOfDate());
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.dispositionService.isNextDispositionActionEligible(recordFolder));
                    }
                });
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_RM_SEARCH));
                        TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordFolderTest.this.nodeService.getProperty(recordFolder, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                        TestCase.assertNotNull((Object)MoveRecordFolderTest.this.nodeService.getProperty(recordFolder, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                    }
                });
            }

            @Override
            public void when() throws Exception {
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        MoveRecordFolderTest.this.fileFolderService.move(recordFolder, destinationRecordCategory, GUID.generate());
                    }
                });
            }

            @Override
            public void then() {
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                        DispositionAction dispositionAction = MoveRecordFolderTest.this.dispositionService.getNextDispositionAction(recordFolder);
                        TestCase.assertNotNull((Object)dispositionAction);
                        TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                        TestCase.assertNotNull((Object)dispositionAction.getAsOfDate());
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.dispositionService.isNextDispositionActionEligible(recordFolder));
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_RM_SEARCH));
                        TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordFolderTest.this.nodeService.getProperty(recordFolder, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                        TestCase.assertNotNull((Object)MoveRecordFolderTest.this.nodeService.getProperty(recordFolder, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                    }
                });
            }
        });
    }

    public void testMoveRecordFolderBeforeCutOffIntoAFolderWithNoDisposition() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(null, false){
            NodeRef recordFolder;
            NodeRef destinationRecordCategory;

            @Override
            public void given() {
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        NodeRef rcOne = MoveRecordFolderTest.this.createRecordCategory(false);
                        destinationRecordCategory = MoveRecordFolderTest.this.filePlanService.createRecordCategory(MoveRecordFolderTest.this.filePlan, GUID.generate());
                        recordFolder = MoveRecordFolderTest.this.recordFolderService.createRecordFolder(rcOne, GUID.generate());
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                        DispositionAction dispositionAction = MoveRecordFolderTest.this.dispositionService.getNextDispositionAction(recordFolder);
                        TestCase.assertNotNull((Object)dispositionAction);
                        TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                        TestCase.assertNotNull((Object)dispositionAction.getAsOfDate());
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.dispositionService.isNextDispositionActionEligible(recordFolder));
                    }
                });
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_RM_SEARCH));
                        TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordFolderTest.this.nodeService.getProperty(recordFolder, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                        TestCase.assertNotNull((Object)MoveRecordFolderTest.this.nodeService.getProperty(recordFolder, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                    }
                });
            }

            @Override
            public void when() throws Exception {
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        MoveRecordFolderTest.this.fileFolderService.move(recordFolder, destinationRecordCategory, GUID.generate());
                    }
                });
            }

            @Override
            public void then() {
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        TestCase.assertFalse((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                        TestCase.assertNull((Object)MoveRecordFolderTest.this.dispositionService.getNextDispositionAction(recordFolder));
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_RM_SEARCH));
                    }
                });
            }
        });
    }

    public void testMoveRecordFolderWithRecordsBeforeCutOffRecordLevelDisposition() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(null, false){
            NodeRef record;
            NodeRef recordFolder;
            NodeRef destinationRecordCategory;

            @Override
            public void given() {
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        NodeRef rcOne = MoveRecordFolderTest.this.createRecordCategory(true);
                        destinationRecordCategory = MoveRecordFolderTest.this.createRecordCategory(true);
                        recordFolder = MoveRecordFolderTest.this.recordFolderService.createRecordFolder(rcOne, GUID.generate());
                        record = MoveRecordFolderTest.this.utils.createRecord(recordFolder, GUID.generate());
                        TestCase.assertFalse((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                        TestCase.assertNull((Object)MoveRecordFolderTest.this.dispositionService.getNextDispositionAction(recordFolder));
                        DispositionAction dispositionAction = MoveRecordFolderTest.this.dispositionService.getNextDispositionAction(record);
                        TestCase.assertNotNull((Object)dispositionAction);
                        TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                        TestCase.assertNotNull((Object)dispositionAction.getAsOfDate());
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.dispositionService.isNextDispositionActionEligible(record));
                    }
                });
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_RM_SEARCH));
                        TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordFolderTest.this.nodeService.getProperty(record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                        TestCase.assertNotNull((Object)MoveRecordFolderTest.this.nodeService.getProperty(record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                    }
                });
            }

            @Override
            public void when() throws Exception {
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        MoveRecordFolderTest.this.fileFolderService.move(recordFolder, destinationRecordCategory, GUID.generate());
                    }
                });
            }

            @Override
            public void then() {
                MoveRecordFolderTest.this.doTestInTransaction(new BaseRMTestCase.VoidTest(){

                    @Override
                    public void runImpl() throws Exception {
                        TestCase.assertFalse((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                        TestCase.assertNull((Object)MoveRecordFolderTest.this.dispositionService.getNextDispositionAction(recordFolder));
                        DispositionAction dispositionAction = MoveRecordFolderTest.this.dispositionService.getNextDispositionAction(record);
                        TestCase.assertNotNull((Object)dispositionAction);
                        TestCase.assertNotNull((String)"cutoff", (Object)dispositionAction.getName());
                        TestCase.assertNotNull((Object)dispositionAction.getAsOfDate());
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.dispositionService.isNextDispositionActionEligible(record));
                        TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_RM_SEARCH));
                        TestCase.assertEquals((Object)"cutoff", (Object)MoveRecordFolderTest.this.nodeService.getProperty(record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                        TestCase.assertNotNull((Object)MoveRecordFolderTest.this.nodeService.getProperty(record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                    }
                });
            }
        });
    }

    public void testMoveRecordFolderFromNoDisToDis() throws Exception {
        final NodeRef recordFolder = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef recordCategory = MoveRecordFolderTest.this.filePlanService.createRecordCategory(MoveRecordFolderTest.this.filePlan, "Caitlin Reed");
                return MoveRecordFolderTest.this.recordFolderService.createRecordFolder(recordCategory, "Grace Wetherall");
            }

            public void test(NodeRef result) throws Exception {
                TestCase.assertNotNull((Object)result);
                TestCase.assertNull((Object)MoveRecordFolderTest.this.dispositionService.getDispositionSchedule(result));
                TestCase.assertFalse((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(result, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)MoveRecordFolderTest.this.permissionService.hasPermission(result, "Filing"));
            }
        });
        final NodeRef record = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return MoveRecordFolderTest.this.fileFolderService.create(recordFolder, "mytest.txt", ContentModel.TYPE_CONTENT).getNodeRef();
            }

            public void test(NodeRef result) throws Exception {
                TestCase.assertNotNull((Object)result);
                TestCase.assertNull((Object)MoveRecordFolderTest.this.dispositionService.getDispositionSchedule(result));
                TestCase.assertFalse((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(result, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)MoveRecordFolderTest.this.permissionService.hasPermission(result, "Filing"));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                Capability capability = MoveRecordFolderTest.this.capabilityService.getCapability("CreateModifyDestroyFolders");
                TestCase.assertEquals((int)1, (int)capability.evaluate(recordFolder));
                TestCase.assertEquals((int)1, (int)capability.evaluate(recordFolder, MoveRecordFolderTest.this.rmContainer));
                Capability moveCapability = MoveRecordFolderTest.this.capabilityService.getCapability("Move");
                TestCase.assertEquals((int)1, (int)moveCapability.evaluate(recordFolder, MoveRecordFolderTest.this.rmContainer));
                return MoveRecordFolderTest.this.fileFolderService.move(recordFolder, MoveRecordFolderTest.this.rmContainer, null).getNodeRef();
            }

            public void test(NodeRef result) throws Exception {
                TestCase.assertNotNull((Object)result);
                TestCase.assertNotNull((Object)MoveRecordFolderTest.this.dispositionService.getDispositionSchedule(result));
                TestCase.assertTrue((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(result, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
                DispositionAction dispositionAction = MoveRecordFolderTest.this.dispositionService.getNextDispositionAction(result);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertNull((Object)dispositionAction.getAsOfDate());
                TestCase.assertEquals((String)"cutoff", (String)dispositionAction.getName());
                TestCase.assertEquals((int)1, (int)dispositionAction.getEventCompletionDetails().size());
                TestCase.assertFalse((boolean)MoveRecordFolderTest.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
            }
        });
    }

    public void testMoveCutoffRecordFolder() throws Exception {
        final NodeRef destination = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return MoveRecordFolderTest.this.filePlanService.createRecordCategory(MoveRecordFolderTest.this.filePlan, "Caitlin Reed");
            }
        });
        final NodeRef testFolder = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef testFolder = MoveRecordFolderTest.this.recordFolderService.createRecordFolder(MoveRecordFolderTest.this.rmContainer, "Peter Edward Francis");
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                MoveRecordFolderTest.this.rmActionService.executeRecordsManagementAction(testFolder, "completeEvent", params);
                MoveRecordFolderTest.this.rmActionService.executeRecordsManagementAction(testFolder, "cutoff");
                return testFolder;
            }

            public void test(NodeRef testFolder) throws Exception {
                Capability moveCapability = MoveRecordFolderTest.this.capabilityService.getCapability("MoveRecordFolder");
                TestCase.assertEquals((int)-1, (int)moveCapability.evaluate(testFolder, destination));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() throws Exception {
                MoveRecordFolderTest.this.fileFolderService.move(testFolder, destination, null).getNodeRef();
            }
        });
    }

    public void testMoveDestroyedRecordFolder() throws Exception {
        final NodeRef destination = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return MoveRecordFolderTest.this.filePlanService.createRecordCategory(MoveRecordFolderTest.this.filePlan, "Caitlin Reed");
            }
        });
        final NodeRef testFolder = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef testFolder = MoveRecordFolderTest.this.recordFolderService.createRecordFolder(MoveRecordFolderTest.this.rmContainer, "Peter Edward Francis");
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("eventName", "case_closed");
                MoveRecordFolderTest.this.rmActionService.executeRecordsManagementAction(testFolder, "completeEvent", params);
                MoveRecordFolderTest.this.rmActionService.executeRecordsManagementAction(testFolder, "cutoff");
                MoveRecordFolderTest.this.rmActionService.executeRecordsManagementAction(testFolder, "destroy");
                return testFolder;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                Capability moveCapability = MoveRecordFolderTest.this.capabilityService.getCapability("MoveRecordFolder");
                TestCase.assertEquals((int)1, (int)moveCapability.evaluate(testFolder, destination));
                return MoveRecordFolderTest.this.fileFolderService.move(testFolder, destination, null).getNodeRef();
            }

            public void test(NodeRef result) throws Exception {
                TestCase.assertNotNull((Object)result);
            }
        });
    }

    public void testMoveClosedFolder() {
        final NodeRef destination = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                return MoveRecordFolderTest.this.filePlanService.createRecordCategory(MoveRecordFolderTest.this.filePlan, GUID.generate());
            }
        });
        NodeRef testFolder = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef testFolder = MoveRecordFolderTest.this.recordFolderService.createRecordFolder(MoveRecordFolderTest.this.rmContainer, GUID.generate());
                MoveRecordFolderTest.this.recordFolderService.closeRecordFolder(testFolder);
                return testFolder;
            }

            public void test(NodeRef testFolder) throws Exception {
                Capability moveCapability = MoveRecordFolderTest.this.capabilityService.getCapability("MoveRecordFolder");
                TestCase.assertEquals((int)-1, (int)moveCapability.evaluate(testFolder, destination));
            }
        });
    }

    private NodeRef createRecordCategory(boolean recordLevel) {
        NodeRef rc = this.filePlanService.createRecordCategory(this.filePlan, GUID.generate());
        DispositionSchedule dis = this.utils.createBasicDispositionSchedule(rc, GUID.generate(), GUID.generate(), recordLevel, false);
        HashMap<QName, String> adParams = new HashMap<QName, String>(3);
        adParams.put(PROP_DISPOSITION_ACTION_NAME, "cutoff");
        adParams.put(PROP_DISPOSITION_DESCRIPTION, GUID.generate());
        adParams.put(PROP_DISPOSITION_PERIOD, "immediately|0");
        this.dispositionService.addDispositionActionDefinition(dis, adParams);
        return rc;
    }
}

