/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.dod5015.model.dod.aspect;

import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

@BehaviourBean
public class DOD5015RecordAspect
extends BaseBehaviourBean
implements NodeServicePolicies.OnAddAspectPolicy,
DOD5015Model {
    private FilePlanService filePlanService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    @Behaviour(kind=BehaviourKind.CLASS, type="rma:record", notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onAddAspect(NodeRef nodeRef, QName aspect) {
        if (this.nodeService.exists(nodeRef) && !this.nodeService.hasAspect(nodeRef, ASPECT_DOD_5015_RECORD) && this.isDODFilePlan(nodeRef)) {
            this.nodeService.addAspect(nodeRef, ASPECT_DOD_5015_RECORD, null);
        }
    }

    private boolean isDODFilePlan(NodeRef record) {
        boolean result = false;
        NodeRef filePlan = this.filePlanService.getFilePlan(record);
        if (filePlan != null && this.nodeService.exists(filePlan)) {
            result = TYPE_DOD_5015_FILE_PLAN.equals((Object)this.nodeService.getType(filePlan));
        }
        return result;
    }
}

