/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.roles;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.content.ContentStreamer;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class DynamicAuthoritiesGet
extends AbstractWebScript
implements RecordsManagementModel {
    private static final String MESSAGE_PARAMETER_BATCHSIZE_GREATER_THAN_ZERO = "Parameter batchsize should be a number greater than 0.";
    private static final String MESSAGE_PROCESSING_BEGIN = "Processing - BEGIN";
    private static final String MESSAGE_PROCESSING_END = "Processing - END";
    private static final String MESSAGE_PROCESSING_RECORD_END_TEMPLATE = "Processing record {0} - END";
    private static final String MESSAGE_PROCESSING_RECORD_BEGIN_TEMPLATE = "Processing record {0} - BEGIN";
    private static final String MESSAGE_BATCHSIZE_IS_INVALID = "Parameter batchsize is invalid.";
    private static final String MESSAGE_BATCHSIZE_IS_MANDATORY = "Parameter batchsize is mandatory";
    private static final String MESSAGE_NODE_REF_DOES_NOT_EXIST_TEMPLATE = "Parameter parentNodeRef = {0} does not exist.";
    private static final String SUCCESS_STATUS = "success";
    private static Log logger = LogFactory.getLog(DynamicAuthoritiesGet.class);
    private static final String BATCH_SIZE = "batchsize";
    private static final String TOTAL_NUMBER_TO_PROCESS = "maxProcessedRecords";
    private static final String PARAM_EXPORT = "export";
    private static final String PARAM_PARENT_NODE_REF = "parentNodeRef";
    private static final String MODEL_STATUS = "responsestatus";
    private static final String MODEL_MESSAGE = "message";
    private static final String MESSAGE_ALL_TEMPLATE = "Processed {0} records.";
    private static final String MESSAGE_PARTIAL_TEMPLATE = "Processed first {0} records.";
    private static final String MESSAGE_NO_RECORDS_TO_PROCESS = "There where no records to be processed.";
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private NodeService nodeService;
    private PermissionService permissionService;
    private ExtendedSecurityService extendedSecurityService;
    private TransactionService transactionService;
    protected ContentStreamer contentStreamer;
    private FileFolderService fileFolderService;

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setExtendedSecurityService(ExtendedSecurityService extendedSecurityService) {
        this.extendedSecurityService = extendedSecurityService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setContentStreamer(ContentStreamer contentStreamer) {
        this.contentStreamer = contentStreamer;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> buildModel(WebScriptRequest req, WebScriptResponse res) throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Long batchSize = this.getBatchSizeParameter(req);
        Long maxNodeId = this.patchDAO.getMaxAdmNodeID();
        Pair recordAspectPair = this.qnameDAO.getQName(ASPECT_EXTENDED_SECURITY);
        if (recordAspectPair == null) {
            model.put(MODEL_STATUS, SUCCESS_STATUS);
            model.put(MODEL_MESSAGE, MESSAGE_NO_RECORDS_TO_PROCESS);
            logger.info((Object)MESSAGE_NO_RECORDS_TO_PROCESS);
            return model;
        }
        Long totalNumberOfRecordsToProcess = this.getMaxToProccessParameter(req, batchSize);
        boolean attach = this.getExportParameter(req);
        File file = TempFileProvider.createTempFile((String)"processedNodes_", (String)".csv");
        FileWriter writer = new FileWriter(file);
        List<Object> processedNodes = new ArrayList();
        try (BufferedWriter out = new BufferedWriter(writer);){
            NodeRef parentNodeRef = this.getParentNodeRefParameter(req);
            processedNodes = parentNodeRef != null ? this.processChildrenNodes(parentNodeRef, batchSize.intValue(), (Pair<Long, QName>)recordAspectPair, totalNumberOfRecordsToProcess.intValue(), out, attach) : this.processNodes(batchSize, maxNodeId, (Pair<Long, QName>)recordAspectPair, totalNumberOfRecordsToProcess, out, attach);
        }
        int processedNodesSize = processedNodes.size();
        String message = "";
        if (totalNumberOfRecordsToProcess == 0L || totalNumberOfRecordsToProcess > 0L && (long)processedNodesSize < totalNumberOfRecordsToProcess) {
            message = MessageFormat.format(MESSAGE_ALL_TEMPLATE, processedNodesSize);
        }
        if (totalNumberOfRecordsToProcess > 0L && totalNumberOfRecordsToProcess == (long)processedNodesSize) {
            message = MessageFormat.format(MESSAGE_PARTIAL_TEMPLATE, totalNumberOfRecordsToProcess);
        }
        model.put(MODEL_STATUS, SUCCESS_STATUS);
        model.put(MODEL_MESSAGE, message);
        logger.info((Object)message);
        if (attach) {
            try {
                String fileName = file.getName();
                this.contentStreamer.streamContent(req, res, file, null, attach, fileName, model);
                model = null;
            }
            finally {
                if (file != null) {
                    file.delete();
                }
            }
        }
        return model;
    }

    protected boolean getExportParameter(WebScriptRequest req) {
        boolean attach = false;
        String export = req.getParameter(PARAM_EXPORT);
        if (Boolean.parseBoolean(export)) {
            attach = true;
        }
        return attach;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String format = req.getFormat();
        try {
            String location;
            String mimetype = this.getContainer().getFormatRegistry().getMimeType(req.getAgent(), format);
            if (mimetype == null) {
                throw new WebScriptException("Web Script format '" + format + "' is not registered");
            }
            Status status = new Status();
            Cache cache = new Cache(this.getDescription().getRequiredCache());
            Map<String, Object> model = this.buildModel(req, res);
            if (model == null) {
                return;
            }
            model.put("status", status);
            model.put("cache", cache);
            Map templateModel = this.createTemplateParameters(req, res, model);
            int statusCode = status.getCode();
            if (statusCode != 200 && !req.forceSuccessStatus()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Force success status header in response: " + req.forceSuccessStatus()));
                    logger.debug((Object)("Setting status " + statusCode));
                }
                res.setStatus(statusCode);
            }
            if ((location = status.getLocation()) != null && location.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting location to " + location));
                }
                res.setHeader("Location", location);
            }
            res.setCache(cache);
            String callback = null;
            if (this.getContainer().allowCallbacks()) {
                callback = req.getJSONCallback();
            }
            if (format.equals("json") && callback != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rendering JSON callback response: content type=" + Format.JAVASCRIPT.mimetype() + ", status=" + statusCode + ", callback=" + callback));
                }
                res.setContentType(Format.JAVASCRIPT.mimetype() + ";charset=UTF-8");
                res.getWriter().write(callback + "(");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rendering response: content type=" + mimetype + ", status=" + statusCode));
                }
                res.setContentType(mimetype + ";charset=UTF-8");
            }
            this.renderFormatTemplate(format, templateModel, res.getWriter());
            if (format.equals("json") && callback != null) {
                res.getWriter().write(")");
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                StringWriter stack = new StringWriter();
                e.printStackTrace(new PrintWriter(stack));
                logger.debug((Object)("Caught exception; decorating with appropriate status template : " + stack.toString()));
            }
            throw this.createStatusException(e, req, res);
        }
    }

    protected void renderFormatTemplate(String format, Map<String, Object> model, Writer writer) {
        format = format == null ? "" : format;
        String templatePath = this.getDescription().getId() + "." + format;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rendering template '" + templatePath + "'"));
        }
        this.renderTemplate(templatePath, model, writer);
    }

    protected Long getMaxToProccessParameter(WebScriptRequest req, Long batchSize) {
        String totalToBeProcessedRecordsStr = req.getParameter(TOTAL_NUMBER_TO_PROCESS);
        Long totalNumberOfRecordsToProcess = batchSize;
        if (StringUtils.isNotBlank((CharSequence)totalToBeProcessedRecordsStr)) {
            try {
                totalNumberOfRecordsToProcess = Long.parseLong(totalToBeProcessedRecordsStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return totalNumberOfRecordsToProcess;
    }

    protected Long getBatchSizeParameter(WebScriptRequest req) {
        Long size;
        String batchSizeStr = req.getParameter(BATCH_SIZE);
        if (StringUtils.isBlank((CharSequence)batchSizeStr)) {
            logger.info((Object)MESSAGE_BATCHSIZE_IS_MANDATORY);
            throw new WebScriptException(400, MESSAGE_BATCHSIZE_IS_MANDATORY);
        }
        try {
            size = Long.parseLong(batchSizeStr);
            if (size <= 0L) {
                logger.info((Object)MESSAGE_PARAMETER_BATCHSIZE_GREATER_THAN_ZERO);
                throw new WebScriptException(400, MESSAGE_PARAMETER_BATCHSIZE_GREATER_THAN_ZERO);
            }
        }
        catch (NumberFormatException ex) {
            logger.info((Object)MESSAGE_BATCHSIZE_IS_INVALID);
            throw new WebScriptException(400, MESSAGE_BATCHSIZE_IS_INVALID);
        }
        return size;
    }

    protected NodeRef getParentNodeRefParameter(WebScriptRequest req) {
        String parentNodeRefStr = req.getParameter(PARAM_PARENT_NODE_REF);
        NodeRef parentNodeRef = null;
        if (StringUtils.isNotBlank((CharSequence)parentNodeRefStr) && !this.nodeService.exists(parentNodeRef = new NodeRef(parentNodeRefStr))) {
            String message = MessageFormat.format(MESSAGE_NODE_REF_DOES_NOT_EXIST_TEMPLATE, parentNodeRef.toString());
            logger.info((Object)message);
            throw new WebScriptException(400, message);
        }
        return parentNodeRef;
    }

    protected List<NodeRef> processNodes(final Long batchSize, Long maxNodeId, final Pair<Long, QName> recordAspectPair, Long totalNumberOfRecordsToProcess, final BufferedWriter out, final boolean attach) {
        final Long maxRecordsToProcess = totalNumberOfRecordsToProcess;
        final ArrayList<NodeRef> processedNodes = new ArrayList<NodeRef>();
        logger.info((Object)MESSAGE_PROCESSING_BEGIN);
        Long i = 0L;
        while (i < maxNodeId && (maxRecordsToProcess == 0L || (long)processedNodes.size() < maxRecordsToProcess)) {
            final Long currentIndex = i;
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    List nodeIds = DynamicAuthoritiesGet.this.patchDAO.getNodesByAspectQNameId((Long)recordAspectPair.getFirst(), currentIndex, Long.valueOf(currentIndex + batchSize));
                    for (Long nodeId : nodeIds) {
                        if (maxRecordsToProcess != 0L && (long)processedNodes.size() >= maxRecordsToProcess) break;
                        NodeRef record = (NodeRef)DynamicAuthoritiesGet.this.nodeDAO.getNodePair(nodeId).getSecond();
                        String recordName = (String)((Object)DynamicAuthoritiesGet.this.nodeService.getProperty(record, ContentModel.PROP_NAME));
                        logger.info((Object)MessageFormat.format(DynamicAuthoritiesGet.MESSAGE_PROCESSING_RECORD_BEGIN_TEMPLATE, recordName));
                        DynamicAuthoritiesGet.this.processNode(record);
                        logger.info((Object)MessageFormat.format(DynamicAuthoritiesGet.MESSAGE_PROCESSING_RECORD_END_TEMPLATE, recordName));
                        processedNodes.add(record);
                        if (!attach) continue;
                        out.write(recordName);
                        out.write(",");
                        out.write(record.toString());
                        out.write("\n");
                    }
                    return null;
                }
            }, false, true);
            i = i + batchSize;
        }
        logger.info((Object)MESSAGE_PROCESSING_END);
        return processedNodes;
    }

    protected List<NodeRef> processChildrenNodes(NodeRef parentNodeRef, final int batchSize, final Pair<Long, QName> recordAspectPair, final int maxRecordsToProcess, final BufferedWriter out, final boolean attach) {
        final ArrayList<NodeRef> processedNodes = new ArrayList<NodeRef>();
        final List children = this.fileFolderService.search(parentNodeRef, "*", true, true, true);
        logger.info((Object)MESSAGE_PROCESSING_BEGIN);
        for (int i = 0; i < children.size() && (maxRecordsToProcess == 0 || processedNodes.size() < maxRecordsToProcess); i += batchSize) {
            final int currentIndex = i;
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    List nodes = children.subList(currentIndex, Math.min(currentIndex + batchSize, children.size()));
                    for (FileInfo node : nodes) {
                        if (maxRecordsToProcess != 0 && processedNodes.size() >= maxRecordsToProcess) break;
                        NodeRef record = node.getNodeRef();
                        if (!DynamicAuthoritiesGet.this.nodeService.hasAspect(record, (QName)recordAspectPair.getSecond())) continue;
                        String recordName = (String)((Object)DynamicAuthoritiesGet.this.nodeService.getProperty(record, ContentModel.PROP_NAME));
                        logger.info((Object)MessageFormat.format(DynamicAuthoritiesGet.MESSAGE_PROCESSING_RECORD_BEGIN_TEMPLATE, recordName));
                        DynamicAuthoritiesGet.this.processNode(record);
                        logger.info((Object)MessageFormat.format(DynamicAuthoritiesGet.MESSAGE_PROCESSING_RECORD_END_TEMPLATE, recordName));
                        processedNodes.add(record);
                        if (!attach) continue;
                        out.write(recordName);
                        out.write(",");
                        out.write(record.toString());
                        out.write("\n");
                    }
                    return null;
                }
            }, false, true);
        }
        logger.info((Object)MESSAGE_PROCESSING_END);
        return processedNodes;
    }

    protected void processNode(NodeRef nodeRef) {
        Map readers = (Map)((Object)this.nodeService.getProperty(nodeRef, PROP_READERS));
        Map writers = (Map)((Object)this.nodeService.getProperty(nodeRef, PROP_WRITERS));
        this.nodeService.removeAspect(nodeRef, ASPECT_EXTENDED_SECURITY);
        this.permissionService.clearPermission(nodeRef, "ROLE_EXTENDED_READER");
        this.permissionService.clearPermission(nodeRef, "ROLE_EXTENDED_WRITER");
        if (this.nodeService.hasAspect(nodeRef, ASPECT_RECORD)) {
            Set<String> readersKeySet = null;
            if (readers != null) {
                readersKeySet = readers.keySet();
            }
            Set<String> writersKeySet = null;
            if (writers != null) {
                writersKeySet = writers.keySet();
            }
            this.extendedSecurityService.set(nodeRef, readersKeySet, writersKeySet);
        }
    }
}

