/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.fileplan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.util.RMContainerCacheManager;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.springframework.extensions.surf.util.I18NUtil;

public class FilePlanServiceImpl
extends ServiceBaseImpl
implements FilePlanService,
RecordsManagementModel {
    private static final String MSG_DUP_ROOT = "rm.service.dup-root";
    private static final String MSG_ROOT_TYPE = "rm.service.root-type";
    private static final String MSG_PATH_NODE = "rm.service.path-node";
    private static final String MSG_NO_ROOT = "rm.service.no-root";
    private static final String MSG_CONTAINER_PARENT_TYPE = "rm.service.container-parent-type";
    private static final String MSG_CONTAINER_TYPE = "rm.service.container-type";
    private static final String MSG_CONTAINER_EXPECTED = "rm.service.container-expected";
    private static final String NAME_UNFILED_CONTAINER = "Unfiled Records";
    private static final String NAME_HOLD_CONTAINER = "Holds";
    private static final String NAME_TRANSFER_CONTAINER = "Transfers";
    private static final String FILE_PLAN_CONTAINER = "documentLibrary";
    private SimpleCache<Pair<NodeRef, String>, NodeRef> rootContainerCache;
    private FilePlanRoleService filePlanRoleService;
    private PermissionService permissionService;
    private NodeDAO nodeDAO;
    private SiteService siteService;
    private RMContainerCacheManager rmContainerCacheManager;

    public FilePlanRoleService getFilePlanRoleService() {
        if (this.filePlanRoleService == null) {
            this.filePlanRoleService = (FilePlanRoleService)this.applicationContext.getBean("FilePlanRoleService");
        }
        return this.filePlanRoleService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        }
        return this.permissionService;
    }

    public NodeDAO getNodeDAO() {
        if (this.nodeDAO == null) {
            this.nodeDAO = (NodeDAO)this.applicationContext.getBean("nodeDAO");
        }
        return this.nodeDAO;
    }

    public SiteService getSiteService() {
        if (this.siteService == null) {
            this.siteService = (SiteService)this.applicationContext.getBean("SiteService");
        }
        return this.siteService;
    }

    @Override
    public Set<NodeRef> getFilePlans() {
        return this.getFilePlans(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
    }

    public void setRootContainerCache(SimpleCache<Pair<NodeRef, String>, NodeRef> rootContainerCache) {
        this.rootContainerCache = rootContainerCache;
    }

    public void setRmContainerCacheManager(RMContainerCacheManager rmContainerCacheManager) {
        this.rmContainerCacheManager = rmContainerCacheManager;
    }

    @Override
    public Set<NodeRef> getFilePlans(final StoreRef storeRef) {
        ParameterCheck.mandatory((String)"storeRef", (Object)storeRef);
        final HashSet<NodeRef> results = new HashSet<NodeRef>();
        HashSet<QName> aspects = new HashSet<QName>(1);
        aspects.add(ASPECT_RECORDS_MANAGEMENT_ROOT);
        if (this.rmContainerCacheManager.isCached(storeRef)) {
            return new HashSet<NodeRef>(this.rmContainerCacheManager.get(storeRef));
        }
        this.getNodeDAO().getNodesWithAspects(aspects, Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE), new NodeDAO.NodeRefQueryCallback(){

            public boolean handle(Pair<Long, NodeRef> nodePair) {
                NodeRef nodeRef = (NodeRef)nodePair.getSecond();
                if (storeRef.equals((Object)nodeRef.getStoreRef())) {
                    results.add(nodeRef);
                    FilePlanServiceImpl.this.rmContainerCacheManager.add(nodeRef);
                }
                return true;
            }
        });
        return results;
    }

    @Override
    public NodeRef getFilePlanBySiteId(String siteId) {
        NodeRef nodeRef;
        NodeRef filePlan = null;
        SiteInfo siteInfo = this.getSiteService().getSite(siteId);
        if (siteInfo != null && this.getSiteService().hasContainer(siteId, FILE_PLAN_CONTAINER) && this.instanceOf(nodeRef = this.getSiteService().getContainer(siteId, FILE_PLAN_CONTAINER), TYPE_FILE_PLAN)) {
            filePlan = nodeRef;
        }
        return filePlan;
    }

    @Override
    public boolean existsUnfiledContainer(NodeRef filePlan) {
        return this.getUnfiledContainer(filePlan) != null;
    }

    @Override
    public NodeRef getUnfiledContainer(NodeRef filePlan) {
        return this.getFilePlanRootContainer(filePlan, NAME_UNFILED_CONTAINER);
    }

    @Override
    public NodeRef getHoldContainer(NodeRef filePlan) {
        return this.getFilePlanRootContainer(filePlan, NAME_HOLD_CONTAINER);
    }

    @Override
    public NodeRef getTransferContainer(NodeRef filePlan) {
        return this.getFilePlanRootContainer(filePlan, NAME_TRANSFER_CONTAINER);
    }

    private NodeRef getFilePlanRootContainer(NodeRef filePlan, String containerName) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        if (!this.isFilePlan(filePlan)) {
            throw new AlfrescoRuntimeException("Unable to get the container " + containerName + ", because passed node is not a file plan.");
        }
        NodeRef result = null;
        Pair key = new Pair((Object)filePlan, (Object)containerName);
        if (!this.rootContainerCache.contains((Serializable)key)) {
            List assocs = this.nodeService.getChildAssocs(filePlan, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)containerName));
            if (assocs.size() > 1) {
                throw new AlfrescoRuntimeException("Unable to get unfiled conatiner " + containerName + ".");
            }
            if (assocs.size() == 1) {
                result = ((ChildAssociationRef)assocs.get(0)).getChildRef();
                this.rootContainerCache.put((Serializable)key, (Object)result);
            }
        } else {
            result = (NodeRef)this.rootContainerCache.get((Serializable)key);
        }
        return result;
    }

    @Override
    public NodeRef createUnfiledContainer(NodeRef filePlan) {
        return this.createFilePlanRootContainer(filePlan, TYPE_UNFILED_RECORD_CONTAINER, NAME_UNFILED_CONTAINER);
    }

    @Override
    public NodeRef createHoldContainer(NodeRef filePlan) {
        return this.createFilePlanRootContainer(filePlan, TYPE_HOLD_CONTAINER, NAME_HOLD_CONTAINER);
    }

    @Override
    public NodeRef createTransferContainer(NodeRef filePlan) {
        return this.createFilePlanRootContainer(filePlan, TYPE_TRANSFER_CONTAINER, NAME_TRANSFER_CONTAINER);
    }

    private NodeRef createFilePlanRootContainer(NodeRef filePlan, QName containerType, String containerName) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        if (!this.isFilePlan(filePlan)) {
            throw new AlfrescoRuntimeException("Unable to create file plan root container, because passed node is not a file plan.");
        }
        String allRoles = this.getFilePlanRoleService().getAllRolesContainerGroup(filePlan);
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NAME, containerName);
        NodeRef container = this.nodeService.createNode(filePlan, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)containerName), containerType, properties).getChildRef();
        this.getPermissionService().setInheritParentPermissions(container, false);
        this.getPermissionService().setPermission(container, allRoles, "ReadRecords", true);
        this.nodeService.addAspect(container, RuleModel.ASPECT_IGNORE_INHERITED_RULES, null);
        return container;
    }

    @Override
    public NodeRef createFilePlan(NodeRef parent, String name, QName type, Map<QName, Serializable> properties) {
        ParameterCheck.mandatory((String)"parent", (Object)parent);
        ParameterCheck.mandatory((String)"name", (Object)name);
        ParameterCheck.mandatory((String)"type", (Object)type);
        if (this.isFilePlanComponent(parent)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_DUP_ROOT));
        }
        if (!TYPE_FILE_PLAN.equals((Object)type) && !this.dictionaryService.isSubClass(type, TYPE_FILE_PLAN)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_ROOT_TYPE, (Object[])new Object[]{type.toString()}));
        }
        HashMap<QName, Object> rmRootProps = new HashMap<QName, Object>(1);
        if (properties != null && properties.size() != 0) {
            rmRootProps.putAll(properties);
        }
        rmRootProps.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef assocRef = this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), type, rmRootProps);
        return assocRef.getChildRef();
    }

    @Override
    public NodeRef createFilePlan(NodeRef parent, String name, Map<QName, Serializable> properties) {
        return this.createFilePlan(parent, name, TYPE_FILE_PLAN, properties);
    }

    @Override
    public NodeRef createFilePlan(NodeRef parent, String name) {
        return this.createFilePlan(parent, name, TYPE_FILE_PLAN, null);
    }

    @Override
    public NodeRef createFilePlan(NodeRef parent, String name, QName type) {
        return this.createFilePlan(parent, name, type, null);
    }

    @Override
    public List<NodeRef> getNodeRefPath(NodeRef nodeRef) {
        LinkedList<NodeRef> nodeRefPath = new LinkedList<NodeRef>();
        try {
            this.getNodeRefPathRecursive(nodeRef, nodeRefPath);
        }
        catch (RuntimeException e) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_PATH_NODE, (Object[])new Object[]{nodeRef}), (Throwable)e);
        }
        return nodeRefPath;
    }

    private void getNodeRefPathRecursive(NodeRef nodeRef, Deque<NodeRef> nodeRefPath) {
        if (this.isFilePlanComponent(nodeRef)) {
            nodeRefPath.addFirst(nodeRef);
            if (!this.isFilePlan(nodeRef)) {
                ChildAssociationRef assocRef = this.nodeService.getPrimaryParent(nodeRef);
                if (assocRef == null) {
                    throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NO_ROOT));
                }
                nodeRef = assocRef.getParentRef();
                this.getNodeRefPathRecursive(nodeRef, nodeRefPath);
            }
        }
    }

    @Override
    public NodeRef createRecordCategory(NodeRef parent, String name, QName type, Map<QName, Serializable> properties) {
        ParameterCheck.mandatory((String)"parent", (Object)parent);
        ParameterCheck.mandatory((String)"name", (Object)name);
        ParameterCheck.mandatory((String)"type", (Object)type);
        QName parentType = this.nodeService.getType(parent);
        if (!TYPE_RECORDS_MANAGEMENT_CONTAINER.equals((Object)parentType) && !this.dictionaryService.isSubClass(parentType, TYPE_RECORDS_MANAGEMENT_CONTAINER)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CONTAINER_PARENT_TYPE, (Object[])new Object[]{parentType.toString()}));
        }
        if (!TYPE_RECORD_CATEGORY.equals((Object)type) && !this.dictionaryService.isSubClass(type, TYPE_RECORD_CATEGORY)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CONTAINER_TYPE, (Object[])new Object[]{type.toString()}));
        }
        HashMap<QName, Object> props = new HashMap<QName, Object>(1);
        if (properties != null && properties.size() != 0) {
            props.putAll(properties);
        }
        props.put(ContentModel.PROP_NAME, name);
        return this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)(name.length() > 255 ? name.substring(0, 255) : name)), type, props).getChildRef();
    }

    @Override
    public NodeRef createRecordCategory(NodeRef parent, String name) {
        return this.createRecordCategory(parent, name, TYPE_RECORD_CATEGORY);
    }

    @Override
    public NodeRef createRecordCategory(NodeRef parent, String name, Map<QName, Serializable> properties) {
        return this.createRecordCategory(parent, name, TYPE_RECORD_CATEGORY, properties);
    }

    @Override
    public NodeRef createRecordCategory(NodeRef parent, String name, QName type) {
        return this.createRecordCategory(parent, name, type, null);
    }

    @Override
    public List<NodeRef> getAllContained(NodeRef container) {
        return this.getAllContained(container, false);
    }

    @Override
    public List<NodeRef> getAllContained(NodeRef container, boolean deep) {
        return this.getContained(container, null, deep);
    }

    private List<NodeRef> getContained(NodeRef container, QName typeFilter, boolean deep) {
        ParameterCheck.mandatory((String)"container", (Object)container);
        if (!this.isRecordCategory(container)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CONTAINER_EXPECTED));
        }
        ArrayList<NodeRef> result = new ArrayList<NodeRef>(1);
        List assocs = this.nodeService.getChildAssocs(container, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            NodeRef child = assoc.getChildRef();
            QName childType = this.nodeService.getType(child);
            if (typeFilter == null || typeFilter.equals((Object)childType) || this.dictionaryService.isSubClass(childType, typeFilter)) {
                result.add(child);
            }
            if (!deep || !TYPE_RECORD_CATEGORY.equals((Object)childType) && !this.dictionaryService.isSubClass(childType, TYPE_RECORD_CATEGORY)) continue;
            result.addAll(this.getContained(child, typeFilter, deep));
        }
        return result;
    }

    @Override
    public List<NodeRef> getContainedRecordCategories(NodeRef container) {
        return this.getContainedRecordCategories(container, false);
    }

    @Override
    public List<NodeRef> getContainedRecordCategories(NodeRef container, boolean deep) {
        return this.getContained(container, TYPE_RECORD_CATEGORY, deep);
    }

    @Override
    public List<NodeRef> getContainedRecordFolders(NodeRef container) {
        return this.getContainedRecordFolders(container, false);
    }

    @Override
    public List<NodeRef> getContainedRecordFolders(NodeRef container, boolean deep) {
        return this.getContained(container, TYPE_RECORD_FOLDER, deep);
    }
}

