/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.substitutionsuggestions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.action.parameter.ParameterProcessorComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RmSubstitutionSuggestionsGet
extends DeclarativeWebScript {
    private static final String FRAGMENT_PARAMETER = "fragment";
    private static final String PATH_PARAMETER = "path";
    private static final String UNFILED_PARAMETER = "unfiled";
    private static final String UNFILED = "true";
    private static final String SUBSTITUTIONS_MODEL_KEY = "substitutions";
    private static final String CREATE_CAPABILITY = "Create";
    private static final String VIEW_CAPABILITY = "ViewRecords";
    private static final int DEFAULT_SUBSTITUTION_MINIMUM_FRAGMENT_LENGTH = 0;
    private static final int DEFAULT_MAXIMUM_NUMBER_PATH_SUGGESTIONS = 10;
    private int pathSubstitutionMaximumNumberSuggestions = 10;
    private int substitutionMinimumFragmentSize = 0;
    private ParameterProcessorComponent parameterProcessorComponent;
    private NodeService nodeService;
    private FilePlanService filePlanService;
    private CapabilityService capabilityService;

    public void setParameterProcessorComponent(ParameterProcessorComponent parameterProcessorComponent) {
        this.parameterProcessorComponent = parameterProcessorComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setSubstitutionMinimumFragmentSize(int substitutionMinimumFragmentSize) {
        this.substitutionMinimumFragmentSize = Math.max(substitutionMinimumFragmentSize, 0);
    }

    public void setPathSubstitutionMaximumNumberSuggestions(int pathSubstitutionMaximumNumberSuggestions) {
        this.pathSubstitutionMaximumNumberSuggestions = pathSubstitutionMaximumNumberSuggestions <= 0 ? 10 : pathSubstitutionMaximumNumberSuggestions;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String fragment = req.getParameter(FRAGMENT_PARAMETER);
        String path = req.getParameter(PATH_PARAMETER);
        String unfiledString = req.getParameter(UNFILED_PARAMETER);
        boolean unfiled = unfiledString != null && UNFILED.equals(unfiledString);
        ArrayList<String> substitutionSuggestions = new ArrayList<String>();
        if (fragment != null && fragment.length() >= this.substitutionMinimumFragmentSize) {
            substitutionSuggestions.addAll(this.getSubPathSuggestions(req, path, fragment, unfiled));
            substitutionSuggestions.addAll(this.parameterProcessorComponent.getSubstitutionSuggestions(fragment));
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(SUBSTITUTIONS_MODEL_KEY, substitutionSuggestions);
        return model;
    }

    private List<String> getSubPathSuggestions(WebScriptRequest req, String path, String fragment, boolean unfiled) {
        ArrayList<String> pathSuggestions = new ArrayList<String>();
        if (path != null && path.startsWith("/") && fragment != null) {
            String[] pathFragments = path.split("/");
            NodeRef currentNode = this.getFilePlan(req, unfiled);
            for (String pathFragment : pathFragments) {
                if (pathFragment.isEmpty()) continue;
                boolean foundThisPathFragment = false;
                List children = this.nodeService.getChildAssocs(currentNode);
                for (ChildAssociationRef childAssoc : children) {
                    NodeRef childNodeRef = childAssoc.getChildRef();
                    String fileName = (String)((Object)this.nodeService.getProperty(childNodeRef, ContentModel.PROP_NAME));
                    if (!fileName.equals(pathFragment) || !this.isNodeRefAppropriateForPathSuggestion(childNodeRef, unfiled)) continue;
                    foundThisPathFragment = true;
                    currentNode = childNodeRef;
                    break;
                }
                if (foundThisPathFragment) continue;
                currentNode = null;
                break;
            }
            if (currentNode != null) {
                String lowerCaseFragment = fragment.toLowerCase();
                List children = this.nodeService.getChildAssocs(currentNode);
                for (ChildAssociationRef childAssoc : children) {
                    NodeRef childNodeRef = childAssoc.getChildRef();
                    String fileName = (String)((Object)this.nodeService.getProperty(childNodeRef, ContentModel.PROP_NAME));
                    if (!fragment.isEmpty() && !fileName.toLowerCase().startsWith(lowerCaseFragment) || !this.isNodeRefAppropriateForPathSuggestion(childNodeRef, unfiled)) continue;
                    pathSuggestions.add("/" + fileName);
                    if (pathSuggestions.size() < this.pathSubstitutionMaximumNumberSuggestions) continue;
                    break;
                }
            }
        }
        return pathSuggestions;
    }

    protected NodeRef getFilePlan(WebScriptRequest req, boolean unfiled) {
        NodeRef filePlan = null;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String siteId = (String)templateVars.get("siteid");
        if (siteId != null) {
            filePlan = this.filePlanService.getFilePlanBySiteId(siteId);
        }
        if (filePlan == null) {
            StoreRef storeRef;
            NodeRef nodeRef;
            String storeType = (String)templateVars.get("store_type");
            String storeId = (String)templateVars.get("store_id");
            String id = (String)templateVars.get("id");
            if (!StringUtils.isEmpty((CharSequence)storeType) && !StringUtils.isEmpty((CharSequence)storeId) && !StringUtils.isEmpty((CharSequence)id) && this.filePlanService.isFilePlan(nodeRef = new NodeRef(storeRef = new StoreRef(storeType, storeId), id))) {
                filePlan = nodeRef;
            }
        }
        if (filePlan == null) {
            filePlan = this.filePlanService.getFilePlanBySiteId("rm");
        }
        return unfiled ? this.filePlanService.getUnfiledContainer(filePlan) : filePlan;
    }

    private boolean isNodeRefAppropriateForPathSuggestion(NodeRef nodeRef, boolean unfiled) {
        QName type = this.nodeService.getType(nodeRef);
        boolean isCorrectType = !unfiled && (RecordsManagementModel.TYPE_RECORD_FOLDER.equals((Object)type) || RecordsManagementModel.TYPE_RECORD_CATEGORY.equals((Object)type)) || unfiled && RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER.equals((Object)type);
        boolean canView = false;
        if (isCorrectType) {
            Capability createCapability = this.capabilityService.getCapability(CREATE_CAPABILITY);
            Capability viewCapability = this.capabilityService.getCapability(VIEW_CAPABILITY);
            if (createCapability != null && viewCapability != null) {
                ArrayList<String> requiredCapabilities = new ArrayList<String>();
                requiredCapabilities.add(CREATE_CAPABILITY);
                requiredCapabilities.add(VIEW_CAPABILITY);
                Map<Capability, AccessStatus> map = this.capabilityService.getCapabilitiesAccessState(nodeRef, requiredCapabilities);
                if (map.containsKey(createCapability) && map.containsKey(viewCapability)) {
                    AccessStatus createAccessStatus = map.get(createCapability);
                    AccessStatus viewAccessStatus = map.get(viewCapability);
                    if (createAccessStatus.equals((Object)AccessStatus.ALLOWED) && viewAccessStatus.equals((Object)AccessStatus.ALLOWED)) {
                        canView = true;
                    }
                }
            }
        }
        return isCorrectType && canView;
    }
}

