/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.util.StringUtils;

public class FileToActionTest
extends BaseRMTestCase {
    private static final String PATH = "rmContainer/rmFolder";
    private static final String PATH2 = "/rmContainer/rmFolder";
    private static final String PATH_BAD = "monkey/rmFolder";
    private static final String PATH_CREATE = "rmContainer/newRmFolder";
    private static final String LONG_PATH_CREATE = "/rmContainer/one/two/three/four/newRmFolder";
    private static final String PATH_SUB1 = "rmContainer/${node.cm:title}";

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isUserTest() {
        return true;
    }

    public void testFileToNodeRef() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() throws Exception {
                FileToActionTest.this.initRecord();
                NodeRef unfiledContainer = FileToActionTest.this.filePlanService.getUnfiledContainer(FileToActionTest.this.filePlan);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FileToActionTest.this.permissionService.hasPermission(unfiledContainer, "Filing"));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)FileToActionTest.this.permissionService.hasPermission(FileToActionTest.this.rmFolder, "Filing"));
                Capability capability = FileToActionTest.this.capabilityService.getCapability("FileUnfiledRecords");
                TestCase.assertNotNull((Object)capability);
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(FileToActionTest.this.dmDocument));
            }

            @Override
            public void when() throws Exception {
                HashMap<String, NodeRef> params = new HashMap<String, NodeRef>(1);
                params.put("destinationRecordFolder", FileToActionTest.this.rmFolder);
                FileToActionTest.this.rmActionService.executeRecordsManagementAction(FileToActionTest.this.dmDocument, "fileTo", params);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isRecord(FileToActionTest.this.dmDocument));
                TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isFiled(FileToActionTest.this.dmDocument));
                NodeRef parent = FileToActionTest.this.nodeService.getPrimaryParent(FileToActionTest.this.dmDocument).getParentRef();
                TestCase.assertEquals((Object)FileToActionTest.this.rmFolder, (Object)parent);
            }
        });
    }

    private void initRecord() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                FileToActionTest.this.nodeService.setProperty(FileToActionTest.this.dmDocument, ContentModel.PROP_TITLE, (Serializable)((Object)"mytestvalue"));
                FileToActionTest.this.recordService.createRecord(FileToActionTest.this.filePlan, FileToActionTest.this.dmDocument);
                return null;
            }

            public void test(Void result) throws Exception {
                AuthenticationUtil.runAs(() -> {
                    TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isRecord(FileToActionTest.this.dmDocument));
                    TestCase.assertFalse((boolean)FileToActionTest.this.recordService.isFiled(FileToActionTest.this.dmDocument));
                    NodeRef parent = FileToActionTest.this.nodeService.getPrimaryParent(FileToActionTest.this.dmDocument).getParentRef();
                    TestCase.assertEquals((Object)FileToActionTest.this.filePlanService.getUnfiledContainer(FileToActionTest.this.filePlan), (Object)parent);
                    return null;
                }, (String)AuthenticationUtil.getAdminUserName());
            }
        }, this.dmCollaborator);
    }

    public void testFileToPath() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() throws Exception {
                FileToActionTest.this.initRecord();
            }

            @Override
            public void when() throws Exception {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("path", FileToActionTest.PATH);
                FileToActionTest.this.rmActionService.executeRecordsManagementAction(FileToActionTest.this.dmDocument, "fileTo", params);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isRecord(FileToActionTest.this.dmDocument));
                TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isFiled(FileToActionTest.this.dmDocument));
                NodeRef parent = FileToActionTest.this.nodeService.getPrimaryParent(FileToActionTest.this.dmDocument).getParentRef();
                TestCase.assertEquals((Object)FileToActionTest.this.rmFolder, (Object)parent);
            }
        });
    }

    public void testFileToPath2() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){

            @Override
            public void given() throws Exception {
                FileToActionTest.this.initRecord();
            }

            @Override
            public void when() throws Exception {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("path", FileToActionTest.PATH2);
                FileToActionTest.this.rmActionService.executeRecordsManagementAction(FileToActionTest.this.dmDocument, "fileTo", params);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isRecord(FileToActionTest.this.dmDocument));
                TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isFiled(FileToActionTest.this.dmDocument));
                NodeRef parent = FileToActionTest.this.nodeService.getPrimaryParent(FileToActionTest.this.dmDocument).getParentRef();
                TestCase.assertEquals((Object)FileToActionTest.this.rmFolder, (Object)parent);
            }
        });
    }

    public void testCreate() throws Exception {
        this.initRecord();
        this.createRecord(PATH_CREATE, "newRmFolder");
    }

    public void testCreateSub() throws Exception {
        this.initRecord();
        this.createRecord(PATH_SUB1, "mytestvalue", "rmContainer/mytestvalue");
    }

    public void testCreatePath() throws Exception {
        this.initRecord();
        this.createRecord(LONG_PATH_CREATE, "newRmFolder", "rmContainer/one/two/three/four/newRmFolder");
    }

    private void createRecord(String path, String name) {
        this.createRecord(path, name, path);
    }

    private void createRecord(final String path, final String name, String resolvedPath) {
        final String[] pathValues = StringUtils.tokenizeToStringArray((String)resolvedPath, (String)"/");
        final HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("path", path);
        params.put("createRecordPath", true);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                FileInfo createdRecordFolder = FileToActionTest.this.fileFolderService.resolveNamePath(FileToActionTest.this.filePlan, new ArrayList<String>(Arrays.asList(pathValues)), false);
                TestCase.assertNull((Object)createdRecordFolder);
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                params.put("path", path);
                params.put("createRecordPath", true);
                return null;
            }
        }, "admin");
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                FileToActionTest.this.rmActionService.executeRecordsManagementAction(FileToActionTest.this.dmDocument, "fileTo", params);
                return null;
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                FileInfo createdRecordFolder = FileToActionTest.this.fileFolderService.resolveNamePath(FileToActionTest.this.filePlan, new ArrayList<String>(Arrays.asList(pathValues)), false);
                TestCase.assertNotNull((Object)createdRecordFolder);
                TestCase.assertEquals((String)name, (String)createdRecordFolder.getName());
                NodeRef createdRecordFolderNodeRef = createdRecordFolder.getNodeRef();
                TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isRecord(FileToActionTest.this.dmDocument));
                TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isFiled(FileToActionTest.this.dmDocument));
                NodeRef parent = FileToActionTest.this.nodeService.getPrimaryParent(FileToActionTest.this.dmDocument).getParentRef();
                TestCase.assertEquals((Object)createdRecordFolderNodeRef, (Object)parent);
                return null;
            }
        }, "admin");
    }

    public void failureTests() throws Exception {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                FileToActionTest.this.recordService.createRecord(FileToActionTest.this.filePlan, FileToActionTest.this.dmDocument);
                TestCase.assertTrue((boolean)FileToActionTest.this.recordService.isRecord(FileToActionTest.this.dmDocument));
                TestCase.assertFalse((boolean)FileToActionTest.this.recordService.isFiled(FileToActionTest.this.dmDocument));
                NodeRef parent = FileToActionTest.this.nodeService.getPrimaryParent(FileToActionTest.this.dmDocument).getParentRef();
                TestCase.assertEquals((Object)FileToActionTest.this.filePlanService.getUnfiledContainer(FileToActionTest.this.filePlan), (Object)parent);
                return null;
            }
        }, this.dmCollaborator);
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Path is invalid and record create not set."){

            public void run() throws Exception {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("path", FileToActionTest.PATH_BAD);
                FileToActionTest.this.rmActionService.executeRecordsManagementAction(FileToActionTest.this.dmDocument, "fileTo", params);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Path is for a new folder, but create not set."){

            public void run() throws Exception {
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("path", FileToActionTest.PATH_CREATE);
                FileToActionTest.this.rmActionService.executeRecordsManagementAction(FileToActionTest.this.dmDocument, "fileTo", params);
            }
        });
    }
}

