/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class RM2072Test
extends BaseRMTestCase {
    private static final int NUMBER_OF_BATCHES = 1;
    private static final int NUMBER_IN_BATCH = 500;
    private RuleService ruleService;
    private NodeRef ruleFolder;

    @Override
    protected void initServices() {
        super.initServices();
        this.ruleService = (RuleService)this.applicationContext.getBean("RuleService");
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testAutoDeclareAutoFileCreateRecordFolderOnly() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM2072Test.this.ruleFolder = RM2072Test.this.fileFolderService.create(RM2072Test.this.documentLibrary, "mytestfolder", ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef nodeRefA = RM2072Test.this.filePlanService.createRecordCategory(RM2072Test.this.filePlan, "A");
                NodeRef nodeRefB = RM2072Test.this.filePlanService.createRecordCategory(nodeRefA, "B");
                RM2072Test.this.filePlanService.createRecordCategory(nodeRefB, "C");
                Action action = RM2072Test.this.actionService.createAction("create-record");
                action.setParameterValue("file-plan", (Serializable)RM2072Test.this.filePlan);
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.setTitle("my rule");
                rule.setAction(action);
                rule.setExecuteAsynchronously(true);
                RM2072Test.this.ruleService.saveRule(RM2072Test.this.ruleFolder, rule);
                Action fileAction = RM2072Test.this.actionService.createAction("fileTo");
                fileAction.setParameterValue("path", (Serializable)((Object)"/A/B/C/{date.year.long}/{date.month.long}/{date.day.month}"));
                fileAction.setParameterValue("createRecordPath", (Serializable)Boolean.valueOf(true));
                Rule fileRule = new Rule();
                fileRule.setRuleType("inbound");
                fileRule.setTitle("my rule");
                fileRule.setAction(fileAction);
                fileRule.setExecuteAsynchronously(true);
                RM2072Test.this.ruleService.saveRule(RM2072Test.this.filePlanService.getUnfiledContainer(RM2072Test.this.filePlan), fileRule);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertFalse((boolean)RM2072Test.this.ruleService.getRules(RM2072Test.this.ruleFolder).isEmpty());
            }
        });
        ArrayList records = new ArrayList(500);
        int i = 0;
        while (i < 1) {
            final int finali = i++;
            records.addAll(this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<List<NodeRef>>(){

                public List<NodeRef> run() throws Exception {
                    ArrayList<NodeRef> records = new ArrayList<NodeRef>(500);
                    for (int j = 0; j < 500; ++j) {
                        int count = (finali + 1) * (j + 1);
                        String name = "content" + count + ".txt";
                        System.out.println(name + " - creating");
                        NodeRef record = RM2072Test.this.fileFolderService.create(RM2072Test.this.ruleFolder, name, ContentModel.TYPE_CONTENT).getNodeRef();
                        records.add(record);
                    }
                    return records;
                }
            }));
        }
        try {
            while (!records.isEmpty()) {
                Thread.sleep(1000L);
                final Iterator temp = records.iterator();
                this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

                    public Void run() throws Exception {
                        while (temp.hasNext()) {
                            NodeRef record = (NodeRef)temp.next();
                            if (!RM2072Test.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_RECORD) || !RM2072Test.this.recordService.isFiled(record)) continue;
                            String name = (String)((Object)RM2072Test.this.nodeService.getProperty(record, ContentModel.PROP_NAME));
                            System.out.println(name + " - complete");
                            temp.remove();
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }
}

