/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.issue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.util.StringUtils;

public class RM2190Test
extends BaseRMTestCase {
    private static final int NUMBER_OF_BATCHES = 1;
    private static final int NUMBER_IN_BATCH = 10;
    private static final String PATH = "/111/222/333";
    private RuleService ruleService;
    private NodeRef rootFolder;
    private NodeRef folder1;
    private NodeRef folder2;

    @Override
    protected void initServices() {
        super.initServices();
        this.ruleService = (RuleService)this.applicationContext.getBean("RuleService");
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    @Override
    protected boolean isRecordTest() {
        return true;
    }

    public void testUploadDocumentsSimultaneouslyWithRules() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                RM2190Test.this.rootFolder = RM2190Test.this.fileFolderService.create(RM2190Test.this.documentLibrary, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                Action createAction = RM2190Test.this.actionService.createAction("create-record");
                createAction.setParameterValue("file-plan", (Serializable)RM2190Test.this.filePlan);
                Rule declareRule = new Rule();
                declareRule.setRuleType("inbound");
                declareRule.setTitle(GUID.generate());
                declareRule.setAction(createAction);
                declareRule.setExecuteAsynchronously(true);
                declareRule.applyToChildren(true);
                RM2190Test.this.ruleService.saveRule(RM2190Test.this.rootFolder, declareRule);
                RM2190Test.this.folder1 = RM2190Test.this.fileFolderService.create(RM2190Test.this.rootFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                RM2190Test.this.folder2 = RM2190Test.this.fileFolderService.create(RM2190Test.this.rootFolder, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
                Action fileAction = RM2190Test.this.actionService.createAction("fileTo");
                fileAction.setParameterValue("path", (Serializable)((Object)RM2190Test.PATH));
                fileAction.setParameterValue("createRecordPath", (Serializable)Boolean.valueOf(true));
                Rule fileRule = new Rule();
                fileRule.setRuleType("inbound");
                fileRule.setTitle(GUID.generate());
                fileRule.setAction(fileAction);
                fileRule.setExecuteAsynchronously(true);
                RM2190Test.this.ruleService.saveRule(RM2190Test.this.unfiledContainer, fileRule);
                return null;
            }

            public void test(Void result) throws Exception {
                TestCase.assertFalse((boolean)RM2190Test.this.ruleService.getRules(RM2190Test.this.rootFolder).isEmpty());
                TestCase.assertFalse((boolean)RM2190Test.this.ruleService.getRules(RM2190Test.this.unfiledContainer).isEmpty());
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws FileNotFoundException, InterruptedException {
                Thread thread1 = new Thread(){

                    @Override
                    public void run() {
                        List<NodeRef> files = RM2190Test.this.addFilesToFolder(RM2190Test.this.folder1);
                        RM2190Test.this.waitForFilesToBeDeclared(files);
                    }
                };
                Thread thread2 = new Thread(){

                    @Override
                    public void run() {
                        List<NodeRef> files = RM2190Test.this.addFilesToFolder(RM2190Test.this.folder2);
                        RM2190Test.this.waitForFilesToBeDeclared(files);
                    }
                };
                thread1.start();
                thread2.start();
                thread1.join(300000L);
                thread2.join(300000L);
                return null;
            }

            public void test(Void result) throws Exception {
                FileInfo category = RM2190Test.this.fileFolderService.resolveNamePath(RM2190Test.this.filePlan, Arrays.asList(StringUtils.tokenizeToStringArray((String)RM2190Test.PATH, (String)"/", (boolean)false, (boolean)true)));
                TestCase.assertEquals((int)20, (int)RM2190Test.this.nodeService.getChildAssocs(category.getNodeRef()).size());
            }
        });
    }

    private List<NodeRef> addFilesToFolder(final NodeRef folder) {
        ArrayList<NodeRef> records = new ArrayList<NodeRef>(10);
        int i = 0;
        while (i < 1) {
            final int finali = i++;
            records.addAll((Collection<NodeRef>)this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<List<NodeRef>>(){

                public List<NodeRef> run() throws Exception {
                    ArrayList<NodeRef> files = new ArrayList<NodeRef>(10);
                    for (int j = 0; j < 10; ++j) {
                        int count = (finali + 1) * (j + 1);
                        String name = folder.getId() + " - content" + count + ".txt";
                        System.out.println(name + " - creating");
                        NodeRef file = RM2190Test.this.fileFolderService.create(folder, name, ContentModel.TYPE_CONTENT).getNodeRef();
                        files.add(file);
                    }
                    return files;
                }
            }));
        }
        return records;
    }

    private void waitForFilesToBeDeclared(List<NodeRef> files) {
        while (!files.isEmpty()) {
            final Iterator<NodeRef> temp = files.iterator();
            this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

                public Void run() throws Exception {
                    while (temp.hasNext()) {
                        NodeRef record = (NodeRef)temp.next();
                        if (!RM2190Test.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_RECORD) || !RM2190Test.this.recordService.isFiled(record)) continue;
                        String name = (String)((Object)RM2190Test.this.nodeService.getProperty(record, ContentModel.PROP_NAME));
                        System.out.println(name + " - complete");
                        temp.remove();
                    }
                    return null;
                }
            });
        }
    }
}

